/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.base.Charsets;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.StringToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class OrderPreservingPartitioner
implements IPartitioner<StringToken> {
    public static final StringToken MINIMUM = new StringToken("");
    public static final BigInteger CHAR_MASK = new BigInteger("65535");
    private final Token.TokenFactory<String> tokenFactory = new Token.TokenFactory<String>(){

        @Override
        public ByteBuffer toByteArray(Token<String> stringToken) {
            return ByteBuffer.wrap(((String)stringToken.token).getBytes(Charsets.UTF_8));
        }

        @Override
        public Token<String> fromByteArray(ByteBuffer bytes) {
            try {
                return new StringToken(ByteBufferUtil.string(bytes, Charsets.UTF_8));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString(Token<String> stringToken) {
            return (String)stringToken.token;
        }

        @Override
        public Token<String> fromString(String string) {
            return new StringToken(string);
        }
    };

    @Override
    public DecoratedKey<StringToken> decorateKey(ByteBuffer key) {
        return new DecoratedKey<StringToken>(this.getToken(key), key);
    }

    @Override
    public DecoratedKey<StringToken> convertFromDiskFormat(ByteBuffer key) {
        return new DecoratedKey<StringToken>(this.getToken(key), key);
    }

    @Override
    public StringToken midpoint(Token ltoken, Token rtoken) {
        int sigchars = Math.max(((String)((StringToken)ltoken).token).length(), ((String)((StringToken)rtoken).token).length());
        BigInteger left = OrderPreservingPartitioner.bigForString((String)((StringToken)ltoken).token, sigchars);
        BigInteger right = OrderPreservingPartitioner.bigForString((String)((StringToken)rtoken).token, sigchars);
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 16 * sigchars);
        return new StringToken(this.stringForBig((BigInteger)midpair.left, sigchars, (Boolean)midpair.right));
    }

    private static BigInteger bigForString(String str, int sigchars) {
        assert (str.length() <= sigchars);
        BigInteger big = BigInteger.ZERO;
        for (int i = 0; i < str.length(); ++i) {
            int charpos = 16 * (sigchars - (i + 1));
            BigInteger charbig = BigInteger.valueOf(str.charAt(i) & 0xFFFF);
            big = big.or(charbig.shiftLeft(charpos));
        }
        return big;
    }

    private String stringForBig(BigInteger big, int sigchars, boolean remainder) {
        char[] chars = new char[sigchars + (remainder ? 1 : 0)];
        if (remainder) {
            int n = sigchars;
            chars[n] = (char)(chars[n] | 0x8000);
        }
        for (int i = 0; i < sigchars; ++i) {
            int maskpos = 16 * (sigchars - (i + 1));
            chars[i] = (char)(big.and(CHAR_MASK.shiftLeft(maskpos)).shiftRight(maskpos).intValue() & 0xFFFF);
        }
        return new String(chars);
    }

    @Override
    public StringToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public StringToken getRandomToken() {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random r = new Random();
        StringBuilder buffer = new StringBuilder();
        for (int j = 0; j < 16; ++j) {
            buffer.append(chars.charAt(r.nextInt(chars.length())));
        }
        return new StringToken(buffer.toString());
    }

    @Override
    public Token.TokenFactory<String> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public StringToken getToken(ByteBuffer key) {
        String skey;
        try {
            skey = ByteBufferUtil.string(key, Charsets.UTF_8);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("The provided key was not UTF8 encoded.", e);
        }
        return new StringToken(skey);
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> allTokens = new HashMap<Token, Float>();
        ArrayList<Range> sortedRanges = new ArrayList<Range>();
        Token lastToken = sortedTokens.get(sortedTokens.size() - 1);
        for (Token node : sortedTokens) {
            allTokens.put(node, new Float(0.0));
            sortedRanges.add(new Range(lastToken, node));
            lastToken = node;
        }
        for (String ks : DatabaseDescriptor.getTables()) {
            for (CFMetaData cfmd : DatabaseDescriptor.getKSMetaData(ks).cfMetaData().values()) {
                for (Range r : sortedRanges) {
                    allTokens.put(r.right, Float.valueOf(((Float)allTokens.get(r.right)).floatValue() + (float)StorageService.instance.getSplits(ks, cfmd.cfName, r, 1).size()));
                }
            }
        }
        Float total = new Float(0.0);
        for (Float f : allTokens.values()) {
            total = Float.valueOf(total.floatValue() + f.floatValue());
        }
        for (Map.Entry entry : allTokens.entrySet()) {
            allTokens.put((Token)entry.getKey(), Float.valueOf(((Float)entry.getValue()).floatValue() / total.floatValue()));
        }
        return allTokens;
    }
}

