/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.cassandra.dht.AbstractByteOrderedPartitioner;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CollatingOrderPreservingPartitioner
extends AbstractByteOrderedPartitioner {
    static final Collator collator = Collator.getInstance(new Locale("en", "US"));

    @Override
    public BytesToken getToken(ByteBuffer key) {
        String skey;
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        try {
            skey = ByteBufferUtil.string(key, Charsets.UTF_8);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("The provided key was not UTF8 encoded.", e);
        }
        return new BytesToken(ByteBuffer.wrap(collator.getCollationKey(skey).toByteArray()));
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        throw new UnsupportedOperationException();
    }
}

