/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class DropKeyspace
extends Migration {
    private String name;

    protected DropKeyspace() {
    }

    public DropKeyspace(String name) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()), DatabaseDescriptor.getDefsVersion());
        this.name = name;
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(name);
        if (ksm == null) {
            throw new ConfigurationException("Keyspace does not exist.");
        }
        this.rm = DropKeyspace.makeDefinitionMutation(null, ksm, this.newVersion);
    }

    @Override
    public void beforeApplyModels() {
        if (!this.clientMode) {
            Table.open(this.name).snapshot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyModels() throws IOException {
        this.acquireLocks();
        try {
            KSMetaData ksm = DatabaseDescriptor.getTableDefinition(this.name);
            Table table = Table.clear(ksm.name);
            if (table == null) {
                throw new IOException("Table is not active. " + ksm.name);
            }
            for (CFMetaData cfm : ksm.cfMetaData().values()) {
                CFMetaData.purge(cfm);
                if (this.clientMode) continue;
                table.dropCf(cfm.cfId);
            }
            DatabaseDescriptor.clearTableDefinition(ksm, this.newVersion);
            if (!this.clientMode) {
                HintedHandOffManager.renameHints(this.name, null);
            }
        }
        finally {
            this.releaseLocks();
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.DropKeyspace dks = new org.apache.cassandra.db.migration.avro.DropKeyspace();
        dks.ksname = new Utf8(this.name);
        mi.migration = dks;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.DropKeyspace dks = (org.apache.cassandra.db.migration.avro.DropKeyspace)((Object)mi.migration);
        this.name = ((Object)dks.ksname).toString();
    }

    public String toString() {
        return "Drop keyspace: " + this.name;
    }
}

