/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.utils.FastObjectHash;

public class FastHashMap<K, V>
extends FastObjectHash<K>
implements Map<K, V>,
Serializable {
    static final long serialVersionUID = 1L;
    protected transient V[] values_;

    public FastHashMap() {
    }

    public FastHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public FastHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public FastHashMap(Map<K, V> map) {
        this(map.size());
        this.putAll(map);
    }

    @Override
    public FastHashMap<K, V> clone() {
        FastHashMap m = (FastHashMap)super.clone();
        m.values_ = (Object[])this.values_.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this.values_ = new Object[capacity];
        return capacity;
    }

    @Override
    void addEntry(Object key, int index) {
    }

    @Override
    void removeEntry(Object key, int index) {
    }

    @Override
    public V put(K key, V value) {
        Object oldKey;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this.values_[index];
            isNewMapping = false;
        }
        if ((oldKey = this.set_[index]) == FREE) {
            this.addEntry(key, index);
        }
        this.set_[index] = key;
        this.values_[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == FREE);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.set_.length;
        Object[] oldKeys = this.set_;
        V[] oldVals = this.values_;
        this.set_ = new Object[newCapacity];
        Arrays.fill(this.set_, FREE);
        this.values_ = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == FREE || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this.set_[-index - 1], o);
            }
            this.set_[index] = o;
            this.values_[index] = oldVals[i];
        }
    }

    @Override
    public V get(Object key) {
        int index = this.index(key);
        return index < 0 ? null : (V)this.values_[index];
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        super.clear();
        Object[] keys = this.set_;
        V[] vals = this.values_;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = FREE;
            vals[i] = null;
        }
    }

    @Override
    public V remove(Object key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = this.values_[index];
            this.removeAt(index);
            this.removeEntry(key, index);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index) {
        this.values_[index] = null;
        super.removeAt(index);
    }

    @Override
    public Collection<V> values() {
        return Arrays.asList(this.values_);
    }

    @Override
    public Set<K> keySet() {
        return new KeyView();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("This operation is currently not supported.");
    }

    @Override
    public boolean containsValue(Object val) {
        Object[] set = this.set_;
        V[] vals = this.values_;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == FREE || set[i] == REMOVED || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == FREE || set[i] == REMOVED || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contains(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public static void main(String[] args) throws Throwable {
        FastHashMap<String, String> map = new FastHashMap<String, String>();
        map.put("Avinash", "Avinash");
        map.put("Avinash", "Srinivas");
    }

    final class Entry
    implements Map.Entry<K, V> {
        private K key;
        private V val;
        private final int index;

        Entry(K key, V value, int index) {
            this.key = key;
            this.val = value;
            this.index = index;
        }

        void setKey(K aKey) {
            this.key = aKey;
        }

        void setValue0(V aValue) {
            this.val = aValue;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V o) {
            if (FastHashMap.this.values_[this.index] != this.val) {
                throw new ConcurrentModificationException();
            }
            FastHashMap.this.values_[this.index] = o;
            o = this.val;
            this.val = o;
            return o;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Entry e1 = this;
                Map.Entry e2 = (Map.Entry)o;
                return (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey())) && (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    protected class KeyView
    extends MapBackedView<K> {
        protected KeyView() {
        }

        @Override
        public Iterator<K> iterator() {
            return new FastHashMapIterator(FastHashMap.this);
        }

        @Override
        public boolean removeElement(K key) {
            return null != FastHashMap.this.remove(key);
        }

        @Override
        public boolean containsElement(K key) {
            return FastHashMap.this.contains(key);
        }
    }

    protected class FastHashMapIterator<T>
    implements Iterator<T> {
        private int nextIndex_ = -1;
        private int expectedSize_;
        private FastObjectHash<T> tMap_;

        FastHashMapIterator(FastObjectHash<T> tMap) {
            this.expectedSize_ = tMap.size();
            this.tMap_ = tMap;
        }

        @Override
        public boolean hasNext() {
            return this.expectedSize_ > 0;
        }

        @Override
        public T next() {
            this.moveToNextIndex();
            int index = this.nextIndex_;
            --this.expectedSize_;
            return (T)this.tMap_.set_[index];
        }

        private void moveToNextIndex() {
            int i;
            for (i = this.nextIndex_ + 1; i < this.tMap_.set_.length && (this.tMap_.set_[i].equals(FastObjectHash.FREE) || this.tMap_.set_[i].equals(FastObjectHash.REMOVED)); ++i) {
            }
            this.nextIndex_ = i;
        }

        @Override
        public void remove() {
            this.tMap_.removeAt(this.nextIndex_);
            --this.expectedSize_;
        }
    }

    private abstract class MapBackedView<E>
    extends AbstractSet<E>
    implements Set<E>,
    Iterable<E> {
        private MapBackedView() {
        }

        @Override
        public abstract Iterator<E> iterator();

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        @Override
        public boolean contains(Object key) {
            return this.containsElement(key);
        }

        @Override
        public boolean remove(Object o) {
            return this.removeElement(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Iterator<?> i = collection.iterator();
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public void clear() {
            FastHashMap.this.clear();
        }

        @Override
        public boolean add(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return FastHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            Iterator<E> e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Iterator<E> it = this.iterator();
            T[] result = a;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public boolean isEmpty() {
            return FastHashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean changed = false;
            Iterator<E> i = this.iterator();
            while (i.hasNext()) {
                if (collection.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            return changed;
        }
    }
}

