/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.BitSet;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.BloomCalculations;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.Filter;

public class BloomFilter
extends Filter {
    static ICompactSerializer<BloomFilter> serializer_ = new BloomFilterSerializer();
    private BitSet filter_;

    public static ICompactSerializer<BloomFilter> serializer() {
        return serializer_;
    }

    public BloomFilter(int numElements, int bucketsPerElement) {
        this(BloomCalculations.computeBestK(bucketsPerElement), new BitSet(numElements * bucketsPerElement + 20));
    }

    public BloomFilter(int numElements, double maxFalsePosProbability) {
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBucketsAndK(maxFalsePosProbability);
        this.filter_ = new BitSet(numElements * spec.bucketsPerElement + 20);
        this.hashCount = spec.K;
    }

    BloomFilter(int hashes, BitSet filter) {
        this.hashCount = hashes;
        this.filter_ = filter;
    }

    public void clear() {
        this.filter_.clear();
    }

    @Override
    int buckets() {
        return this.filter_.size();
    }

    BitSet filter() {
        return this.filter_;
    }

    @Override
    public boolean isPresent(String key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            if (this.filter_.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public boolean isPresent(byte[] key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            if (this.filter_.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(String key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            this.filter_.set(bucketIndex);
        }
    }

    public void add(byte[] key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            this.filter_.set(bucketIndex);
        }
    }

    public String toString() {
        return this.filter_.toString();
    }

    ICompactSerializer tserializer() {
        return serializer_;
    }

    @Override
    int emptyBuckets() {
        int n = 0;
        for (int i = 0; i < this.buckets(); ++i) {
            if (this.filter_.get(i)) continue;
            ++n;
        }
        return n;
    }

    public static BloomFilter alwaysMatchingBloomFilter() {
        BitSet set = new BitSet(64);
        set.set(0, 64);
        return new BloomFilter(1, set);
    }
}

