/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.cassandra.concurrent.IExecutorMBean;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class NodeProbe {
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final String ssObjName = "org.apache.cassandra.service:type=StorageService";
    private static final String HOST_OPTION = "host";
    private static final String PORT_OPTION = "port";
    private static final int defaultPort = 8080;
    private static Options options = null;
    private CommandLine cmd = null;
    private String host;
    private int port;
    private MBeanServerConnection mbeanServerConn;
    private StorageServiceMBean ssProxy;
    private MemoryMXBean memProxy;
    private RuntimeMXBean runtimeProxy;

    private NodeProbe(String[] cmdArgs) throws ParseException, IOException {
        this.parseArgs(cmdArgs);
        this.host = this.cmd.getOptionValue(HOST_OPTION);
        String portNum = this.cmd.getOptionValue(PORT_OPTION);
        if (portNum != null) {
            try {
                this.port = Integer.parseInt(portNum);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Port must be a number");
            }
        } else {
            this.port = 8080;
        }
        this.connect();
    }

    public NodeProbe(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.connect();
    }

    public NodeProbe(String host) throws IOException {
        this.host = host;
        this.port = 8080;
        this.connect();
    }

    private void connect() throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, this.host, this.port));
        JMXConnector jmxc = JMXConnectorFactory.connect(jmxUrl, null);
        this.mbeanServerConn = jmxc.getMBeanServerConnection();
        try {
            ObjectName name = new ObjectName(ssObjName);
            this.ssProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageServiceMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        this.memProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Memory", MemoryMXBean.class);
        this.runtimeProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
    }

    public Map<Range, List<EndPoint>> getRangeToEndpointMap() {
        return this.ssProxy.getRangeToEndPointMap();
    }

    public String getLiveNodes() {
        return this.ssProxy.getLiveNodes();
    }

    public String getUnreachableNodes() {
        return this.ssProxy.getUnreachableNodes();
    }

    public String getToken() {
        return this.ssProxy.getToken();
    }

    public int getCurrentGenerationNumber() {
        return this.ssProxy.getCurrentGenerationNumber();
    }

    public String getLoadInfo() {
        return this.ssProxy.getLoadInfo();
    }

    public void forceTableCleanup() throws IOException {
        this.ssProxy.forceTableCleanup();
    }

    public void bootStrapNodes(String nodeList) throws UnknownHostException {
        this.ssProxy.loadAll(nodeList);
    }

    public void forceTableCompaction() throws IOException {
        this.ssProxy.forceTableCompaction();
    }

    public void forceTableFlushBinary(String tableName) throws IOException {
        this.ssProxy.forceTableFlushBinary(tableName);
    }

    public void printRing(PrintStream outs) {
        Map<Range, List<EndPoint>> rangeMap = this.getRangeToEndpointMap();
        ArrayList<Range> ranges = new ArrayList<Range>(rangeMap.keySet());
        Collections.sort(ranges);
        int counter = 0;
        outs.print(String.format("%-46s ", "Starting Token"));
        outs.print(String.format("%-44s ", "Ending Token"));
        outs.print(String.format("%-4s ", "Size"));
        outs.print(String.format("%-15s", "Address"));
        outs.println("Ring");
        for (Range range : ranges) {
            List<EndPoint> endpoints = rangeMap.get(range);
            outs.print(String.format("%-46s ", range.left()));
            outs.print(String.format("%-46s ", range.right()));
            outs.print(String.format("%2d ", endpoints.size()));
            outs.print(String.format("%-15s", endpoints.get(0).getHost()));
            String asciiRingArt = counter == 0 ? "|<--|" : (counter == rangeMap.size() - 1 ? "|-->|" : (rangeMap.size() > 4 && counter % 2 == 0 ? "v   |" : (rangeMap.size() > 4 && counter % 2 != 0 ? "|   ^" : "|   |")));
            outs.println(asciiRingArt);
            ++counter;
        }
    }

    public void printColumnFamilyStats(PrintStream outs) {
        try {
            HashMap cfstoreMap = new HashMap();
            ObjectName query = new ObjectName("org.apache.cassandra.db:type=ColumnFamilyStores,*");
            Set<ObjectName> result = this.mbeanServerConn.queryNames(query, null);
            for (ObjectName objectName : result) {
                String tableName = objectName.getKeyProperty("name");
                ColumnFamilyStoreMBean cfsProxy = JMX.newMBeanProxy(this.mbeanServerConn, objectName, ColumnFamilyStoreMBean.class);
                if (!cfstoreMap.containsKey(tableName)) {
                    ArrayList<ColumnFamilyStoreMBean> columnFamilies = new ArrayList<ColumnFamilyStoreMBean>();
                    columnFamilies.add(cfsProxy);
                    cfstoreMap.put(tableName, columnFamilies);
                    continue;
                }
                ((List)cfstoreMap.get(tableName)).add(cfsProxy);
            }
            for (String tableName : cfstoreMap.keySet()) {
                List columnFamilies = (List)cfstoreMap.get(tableName);
                int tableReadCount = 0;
                int tableWriteCount = 0;
                int tablePendingTasks = 0;
                double tableTotalReadTime = 0.0;
                double tableTotalWriteTime = 0.0;
                outs.println("Keyspace: " + tableName);
                for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                    int writeCount = cfstore.getWriteCount();
                    int readCount = cfstore.getReadCount();
                    tableReadCount += readCount;
                    tableTotalReadTime += cfstore.getReadLatency() * (double)readCount;
                    tableWriteCount += writeCount;
                    tableTotalWriteTime += cfstore.getWriteLatency() * (double)writeCount;
                    tablePendingTasks += cfstore.getPendingTasks();
                }
                double tableReadLatency = Double.NaN;
                double tableWriteLatency = Double.NaN;
                if ((float)tableReadCount > 0.0f) {
                    tableReadLatency = tableTotalReadTime / (double)tableReadCount;
                }
                if ((float)tableWriteCount > 0.0f) {
                    tableWriteLatency = tableTotalWriteTime / (double)tableWriteCount;
                }
                outs.println("\tRead Count: " + tableReadCount);
                outs.println("\tRead Latency: " + String.format("%01.3f", tableReadLatency) + " ms.");
                outs.println("\tWrite Count: " + tableWriteCount);
                outs.println("\tWrite Latency: " + String.format("%01.3f", tableWriteLatency) + " ms.");
                outs.println("\tPending Tasks: " + tablePendingTasks);
                for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                    outs.println("\t\tColumn Family: " + cfstore.getColumnFamilyName());
                    outs.println("\t\tMemtable Columns Count: " + cfstore.getMemtableColumnsCount());
                    outs.println("\t\tMemtable Data Size: " + cfstore.getMemtableDataSize());
                    outs.println("\t\tMemtable Switch Count: " + cfstore.getMemtableSwitchCount());
                    outs.println("\t\tRead Count: " + cfstore.getReadCount());
                    outs.println("\t\tRead Latency: " + String.format("%01.3f", cfstore.getReadLatency()) + " ms.");
                    outs.println("\t\tWrite Count: " + cfstore.getWriteCount());
                    outs.println("\t\tWrite Latency: " + String.format("%01.3f", cfstore.getWriteLatency()) + " ms.");
                    outs.println("\t\tPending Tasks: " + cfstore.getPendingTasks());
                    outs.println("");
                }
                outs.println("----------------");
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public void printCluster(PrintStream outs) {
        for (String upNode : this.getLiveNodes().split("\\s+")) {
            if (upNode.length() <= 0) continue;
            outs.println(String.format("%-21s up", upNode));
        }
        for (String downNode : this.getUnreachableNodes().split("\\s+")) {
            if (downNode.length() <= 0) continue;
            outs.println(String.format("%-21s down", downNode));
        }
    }

    public void printInfo(PrintStream outs) {
        outs.println(this.getToken());
        outs.println(String.format("%-17s: %s", "Load Info", this.getLoadInfo()));
        outs.println(String.format("%-17s: %s", "Generation No", this.getCurrentGenerationNumber()));
        long secondsUp = this.runtimeProxy.getUptime() / 1000L;
        outs.println(String.format("%-17s: %d", "Uptime (seconds)", secondsUp));
        MemoryUsage heapUsage = this.memProxy.getHeapMemoryUsage();
        double memUsed = (double)heapUsage.getUsed() / 1048576.0;
        double memMax = (double)heapUsage.getMax() / 1048576.0;
        outs.println(String.format("%-17s: %.2f / %.2f", "Heap Memory (MB)", memUsed, memMax));
    }

    public void takeSnapshot(String snapshotName) throws IOException {
        this.ssProxy.takeAllSnapshot(snapshotName);
    }

    public void clearSnapshot() throws IOException {
        this.ssProxy.clearSnapshot();
    }

    public void printThreadPoolStats(PrintStream outs) {
        try {
            ObjectName query = new ObjectName("org.apache.cassandra.concurrent:type=*");
            Set<ObjectName> result = this.mbeanServerConn.queryNames(query, null);
            for (ObjectName objectName : result) {
                String poolName = objectName.getKeyProperty("type");
                IExecutorMBean threadPoolProxy = JMX.newMBeanProxy(this.mbeanServerConn, objectName, IExecutorMBean.class);
                outs.println(poolName + ", pending tasks=" + threadPoolProxy.getPendingTasks());
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    private String[] getArgs() {
        return this.cmd.getArgs();
    }

    private void parseArgs(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cmd = parser.parse(options, args);
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        String header = String.format("%nAvailable commands: ring, cluster, info, cleanup, compact, cfstats, snapshot [name], clearsnapshot, bootstrap, tpstats, flush_binary", new Object[0]);
        String usage = String.format("java %s -host <arg> <command>%n", NodeProbe.class.getName());
        hf.printHelp(usage, "", options, header);
    }

    public static void main(String[] args) throws IOException {
        String[] arguments;
        String cmdName;
        NodeProbe probe = null;
        try {
            probe = new NodeProbe(args);
        }
        catch (ParseException pe) {
            System.err.println(pe.getMessage());
            NodeProbe.printUsage();
            System.exit(1);
        }
        catch (IOException ioe) {
            System.err.println("Error connecting to remote JMX agent!");
            ioe.printStackTrace();
            System.exit(3);
        }
        if (probe.getArgs().length < 1) {
            System.err.println("Missing argument for command.");
            NodeProbe.printUsage();
            System.exit(1);
        }
        if ((cmdName = (arguments = probe.getArgs())[0]).equals("ring")) {
            probe.printRing(System.out);
        } else if (cmdName.equals("cluster")) {
            probe.printCluster(System.out);
        } else if (cmdName.equals("info")) {
            probe.printInfo(System.out);
        } else if (cmdName.equals("cleanup")) {
            probe.forceTableCleanup();
        } else if (cmdName.equals("compact")) {
            probe.forceTableCompaction();
        } else if (cmdName.equals("cfstats")) {
            probe.printColumnFamilyStats(System.out);
        } else if (cmdName.equals("snapshot")) {
            String snapshotName = "";
            if (arguments.length > 1) {
                snapshotName = arguments[1];
            }
            probe.takeSnapshot(snapshotName);
        } else if (cmdName.equals("clearsnapshot")) {
            probe.clearSnapshot();
        } else if (cmdName.equals("bootstrap")) {
            if (arguments.length == 2) {
                probe.bootStrapNodes(arguments[1]);
            } else {
                System.err.println(cmdName + " needs a node to work with");
                NodeProbe.printUsage();
                System.exit(1);
            }
        } else if (cmdName.equals("tpstats")) {
            probe.printThreadPoolStats(System.out);
        } else if (cmdName.equals("flush_binary")) {
            if (probe.getArgs().length < 2) {
                System.err.println("Missing keyspace argument.");
                NodeProbe.printUsage();
                System.exit(1);
            }
            probe.forceTableFlushBinary(probe.getArgs()[1]);
        } else {
            System.err.println("Unrecognized command: " + cmdName + ".");
            NodeProbe.printUsage();
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        options = new Options();
        Option optHost = new Option(HOST_OPTION, true, "node hostname or ip address");
        optHost.setRequired(true);
        options.addOption(optHost);
        options.addOption(PORT_OPTION, true, "remote jmx agent port number");
    }
}

