/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tools.MembershipCleaner;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class MembershipCleanerVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(MembershipCleanerVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        block6: {
            byte[] body = message.getMessageBody();
            try {
                Set<String> nodes;
                Iterator<String> i$;
                DataInputBuffer bufIn = new DataInputBuffer();
                bufIn.reset(body, body.length);
                MembershipCleaner.MembershipCleanerMessage mcMessage = MembershipCleaner.MembershipCleanerMessage.serializer().deserialize(bufIn);
                String target = mcMessage.getTarget();
                logger_.info((Object)("Removing the node [" + target + "] from membership"));
                EndPoint targetEndPoint = new EndPoint(target, DatabaseDescriptor.getControlPort());
                StorageService.instance().removeTokenState(targetEndPoint);
                Map<String, byte[]> headers = message.getHeaders();
                headers.remove(StorageService.getLocalStorageEndPoint().getHost());
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Number of nodes in the header " + headers.size()));
                }
                if ((i$ = (nodes = headers.keySet()).iterator()).hasNext()) {
                    String node = i$.next();
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("Processing node " + node));
                    }
                    headers.remove(node);
                    EndPoint targetNode = new EndPoint(node, DatabaseDescriptor.getStoragePort());
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("Sending a membership clean message to " + targetNode));
                    }
                    MessagingService.getMessagingInstance().sendOneWay(message, targetNode);
                }
            }
            catch (IOException ex) {
                if (!logger_.isDebugEnabled()) break block6;
                logger_.debug((Object)LogUtil.throwableToString(ex));
            }
        }
    }
}

