/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.log4j.Logger;

public class WriteResponseResolver
implements IResponseResolver<Boolean> {
    private static Logger logger_ = Logger.getLogger(WriteResponseResolver.class);

    @Override
    public Boolean resolve(List<Message> responses) throws DigestMismatchException {
        boolean returnValue = false;
        for (Message response : responses) {
            WriteResponse writeResponseMessage = null;
            try {
                writeResponseMessage = WriteResponse.serializer().deserialize(new DataInputStream(new ByteArrayInputStream(response.getMessageBody())));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            boolean result = writeResponseMessage.isSuccess();
            if (!result && logger_.isDebugEnabled()) {
                logger_.debug((Object)("Write at " + response.getFrom() + " may have failed for the key " + writeResponseMessage.key()));
            }
            returnValue |= result;
        }
        return returnValue;
    }

    @Override
    public boolean isDataPresent(List<Message> responses) {
        return true;
    }
}

