/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyNotDefinedException;
import org.apache.cassandra.db.KeyspaceNotDefinedException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.service.ColumnParent;
import org.apache.cassandra.service.ColumnPath;
import org.apache.cassandra.service.InvalidRequestException;
import org.apache.cassandra.service.SliceRange;

public class ThriftValidation {
    static void validateKey(String key) throws InvalidRequestException {
        if (key.isEmpty()) {
            throw new InvalidRequestException("Key may not be empty");
        }
    }

    static void validateCommand(String tablename, String ... columnFamilyNames) throws KeyspaceNotDefinedException, ColumnFamilyNotDefinedException {
        ThriftValidation.validateTable(tablename);
        for (String cfName : columnFamilyNames) {
            if (DatabaseDescriptor.getColumnType(tablename, cfName) != null) continue;
            throw new ColumnFamilyNotDefinedException("Column Family " + cfName + " is invalid.");
        }
    }

    private static void validateTable(String tablename) throws KeyspaceNotDefinedException {
        if (!DatabaseDescriptor.getTables().contains(tablename)) {
            throw new KeyspaceNotDefinedException("Keyspace " + tablename + " does not exist in this schema.");
        }
    }

    public static String validateColumnFamily(String tablename, String cfName) throws InvalidRequestException {
        if (cfName.isEmpty()) {
            throw new InvalidRequestException("non-empty columnfamily is required");
        }
        String cfType = DatabaseDescriptor.getColumnType(tablename, cfName);
        if (cfType == null) {
            throw new InvalidRequestException("unconfigured columnfamily " + cfName);
        }
        return cfType;
    }

    static void validateColumnPath(String tablename, ColumnPath column_path) throws InvalidRequestException {
        ThriftValidation.validateTable(tablename);
        String cfType = ThriftValidation.validateColumnFamily(tablename, column_path.column_family);
        if (cfType.equals("Standard")) {
            if (column_path.super_column != null) {
                throw new InvalidRequestException("supercolumn parameter is invalid for standard CF " + column_path.column_family);
            }
            if (column_path.column == null) {
                throw new InvalidRequestException("column parameter is not optional for standard CF " + column_path.column_family);
            }
        } else if (column_path.super_column == null) {
            throw new InvalidRequestException("supercolumn parameter is not optional for super CF " + column_path.column_family);
        }
        if (column_path.column != null) {
            ThriftValidation.validateColumns(tablename, column_path.column_family, column_path.super_column, Arrays.asList(new byte[][]{column_path.column}));
        }
        if (column_path.super_column != null) {
            ThriftValidation.validateColumns(tablename, column_path.column_family, null, Arrays.asList(new byte[][]{column_path.super_column}));
        }
    }

    static void validateColumnParent(String tablename, ColumnParent column_parent) throws InvalidRequestException {
        ThriftValidation.validateTable(tablename);
        String cfType = ThriftValidation.validateColumnFamily(tablename, column_parent.column_family);
        if (cfType.equals("Standard") && column_parent.super_column != null) {
            throw new InvalidRequestException("columnfamily alone is required for standard CF " + column_parent.column_family);
        }
        if (column_parent.super_column != null) {
            ThriftValidation.validateColumns(tablename, column_parent.column_family, null, Arrays.asList(new byte[][]{column_parent.super_column}));
        }
    }

    static void validateColumnPathOrParent(String tablename, ColumnPath column_path_or_parent) throws InvalidRequestException {
        ThriftValidation.validateTable(tablename);
        String cfType = ThriftValidation.validateColumnFamily(tablename, column_path_or_parent.column_family);
        if (cfType.equals("Standard") && column_path_or_parent.super_column != null) {
            throw new InvalidRequestException("supercolumn may not be specified for standard CF " + column_path_or_parent.column_family);
        }
        if (column_path_or_parent.column != null) {
            ThriftValidation.validateColumns(tablename, column_path_or_parent.column_family, column_path_or_parent.super_column, Arrays.asList(new byte[][]{column_path_or_parent.column}));
        }
        if (column_path_or_parent.super_column != null) {
            ThriftValidation.validateColumns(tablename, column_path_or_parent.column_family, null, Arrays.asList(new byte[][]{column_path_or_parent.super_column}));
        }
    }

    private static void validateColumns(String keyspace, String columnFamilyName, byte[] superColumnName, Iterable<byte[]> column_names) throws InvalidRequestException {
        if (superColumnName != null) {
            if (superColumnName.length > 65535) {
                throw new InvalidRequestException("supercolumn name length must not be greater than 65535");
            }
            if (superColumnName.length == 0) {
                throw new InvalidRequestException("supercolumn name must not be empty");
            }
        }
        AbstractType comparator = ColumnFamily.getComparatorFor(keyspace, columnFamilyName, superColumnName);
        for (byte[] name : column_names) {
            if (name.length > 65535) {
                throw new InvalidRequestException("column name length must not be greater than 65535");
            }
            if (name.length == 0) {
                throw new InvalidRequestException("column name must not be empty");
            }
            try {
                comparator.validate(name);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }
    }

    public static void validateColumns(String keyspace, ColumnParent column_parent, Iterable<byte[]> column_names) throws InvalidRequestException {
        ThriftValidation.validateColumns(keyspace, column_parent.column_family, column_parent.super_column, column_names);
    }

    public static void validateRange(String keyspace, ColumnParent column_parent, SliceRange range) throws InvalidRequestException {
        Comparator<byte[]> orderedComparator;
        AbstractType comparator = ColumnFamily.getComparatorFor(keyspace, column_parent.column_family, column_parent.super_column);
        try {
            comparator.validate(range.start);
            comparator.validate(range.finish);
        }
        catch (MarshalException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        if (range.count < 0) {
            throw new InvalidRequestException("get_slice requires non-negative count");
        }
        Comparator<byte[]> comparator2 = orderedComparator = range.isReversed() ? comparator.getReverseComparator() : comparator;
        if (range.start.length > 0 && range.finish.length > 0 && orderedComparator.compare(range.start, range.finish) > 0) {
            throw new InvalidRequestException("range finish must come after start in the order of traversal");
        }
    }
}

