/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.service.SliceRange;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class SlicePredicate
implements TBase,
Serializable,
Cloneable,
Comparable<SlicePredicate> {
    private static final TStruct STRUCT_DESC = new TStruct("SlicePredicate");
    private static final TField COLUMN_NAMES_FIELD_DESC = new TField("column_names", 15, 1);
    private static final TField SLICE_RANGE_FIELD_DESC = new TField("slice_range", 12, 2);
    public List<byte[]> column_names;
    public SliceRange slice_range;
    public static final int COLUMN_NAMES = 1;
    public static final int SLICE_RANGE = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("column_names", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
            this.put(2, new FieldMetaData("slice_range", 2, (FieldValueMetaData)new StructMetaData(12, SliceRange.class)));
        }
    });

    public SlicePredicate() {
    }

    public SlicePredicate(List<byte[]> column_names, SliceRange slice_range) {
        this();
        this.column_names = column_names;
        this.slice_range = slice_range;
    }

    public SlicePredicate(SlicePredicate other) {
        if (other.isSetColumn_names()) {
            ArrayList<byte[]> __this__column_names = new ArrayList<byte[]>();
            for (byte[] other_element : other.column_names) {
                byte[] temp_binary_element = new byte[other_element.length];
                System.arraycopy(other_element, 0, temp_binary_element, 0, other_element.length);
                __this__column_names.add(temp_binary_element);
            }
            this.column_names = __this__column_names;
        }
        if (other.isSetSlice_range()) {
            this.slice_range = new SliceRange(other.slice_range);
        }
    }

    public SlicePredicate deepCopy() {
        return new SlicePredicate(this);
    }

    @Deprecated
    public SlicePredicate clone() {
        return new SlicePredicate(this);
    }

    public List<byte[]> getColumn_names() {
        return this.column_names;
    }

    public SlicePredicate setColumn_names(List<byte[]> column_names) {
        this.column_names = column_names;
        return this;
    }

    public void unsetColumn_names() {
        this.column_names = null;
    }

    public boolean isSetColumn_names() {
        return this.column_names != null;
    }

    public void setColumn_namesIsSet(boolean value) {
        if (!value) {
            this.column_names = null;
        }
    }

    public SliceRange getSlice_range() {
        return this.slice_range;
    }

    public SlicePredicate setSlice_range(SliceRange slice_range) {
        this.slice_range = slice_range;
        return this;
    }

    public void unsetSlice_range() {
        this.slice_range = null;
    }

    public boolean isSetSlice_range() {
        return this.slice_range != null;
    }

    public void setSlice_rangeIsSet(boolean value) {
        if (!value) {
            this.slice_range = null;
        }
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetColumn_names();
                    break;
                }
                this.setColumn_names((List)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetSlice_range();
                    break;
                }
                this.setSlice_range((SliceRange)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getColumn_names();
            }
            case 2: {
                return this.getSlice_range();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetColumn_names();
            }
            case 2: {
                return this.isSetSlice_range();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof SlicePredicate) {
            return this.equals((SlicePredicate)that);
        }
        return false;
    }

    public boolean equals(SlicePredicate that) {
        if (that == null) {
            return false;
        }
        boolean this_present_column_names = this.isSetColumn_names();
        boolean that_present_column_names = that.isSetColumn_names();
        if (this_present_column_names || that_present_column_names) {
            if (!this_present_column_names || !that_present_column_names) {
                return false;
            }
            if (!((Object)this.column_names).equals(that.column_names)) {
                return false;
            }
        }
        boolean this_present_slice_range = this.isSetSlice_range();
        boolean that_present_slice_range = that.isSetSlice_range();
        if (this_present_slice_range || that_present_slice_range) {
            if (!this_present_slice_range || !that_present_slice_range) {
                return false;
            }
            if (!this.slice_range.equals(that.slice_range)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(SlicePredicate other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        SlicePredicate typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetColumn_names()).compareTo(this.isSetColumn_names());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.column_names, typedOther.column_names);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSlice_range()).compareTo(this.isSetSlice_range());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo((Comparable)this.slice_range, (Comparable)typedOther.slice_range);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 15) {
                        TList _list4 = iprot.readListBegin();
                        this.column_names = new ArrayList<byte[]>(_list4.size);
                        for (int _i5 = 0; _i5 < _list4.size; ++_i5) {
                            byte[] _elem6 = iprot.readBinary();
                            this.column_names.add(_elem6);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 12) {
                        this.slice_range = new SliceRange();
                        this.slice_range.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.column_names != null && this.isSetColumn_names()) {
            oprot.writeFieldBegin(COLUMN_NAMES_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.column_names.size()));
            for (byte[] _iter7 : this.column_names) {
                oprot.writeBinary(_iter7);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.slice_range != null && this.isSetSlice_range()) {
            oprot.writeFieldBegin(SLICE_RANGE_FIELD_DESC);
            this.slice_range.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SlicePredicate(");
        boolean first = true;
        if (this.isSetColumn_names()) {
            sb.append("column_names:");
            if (this.column_names == null) {
                sb.append("null");
            } else {
                sb.append(this.column_names);
            }
            first = false;
        }
        if (this.isSetSlice_range()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("slice_range:");
            if (this.slice_range == null) {
                sb.append("null");
            } else {
                sb.append(this.slice_range);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(SlicePredicate.class, metaDataMap);
    }
}

