/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.db.RowMutationMessage;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.Cachetable;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ICacheExpungeHook;
import org.apache.cassandra.utils.ICachetable;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

class ReadRepairManager {
    private static Logger logger_ = Logger.getLogger(ReadRepairManager.class);
    private static final long expirationTimeInMillis = 2000L;
    private static Lock lock_ = new ReentrantLock();
    private static ReadRepairManager self_ = null;
    private ICachetable<String, Message> readRepairTable_ = new Cachetable<String, Message>(2000L, new ReadRepairPerformer());

    protected ReadRepairManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadRepairManager instance() {
        if (self_ == null) {
            lock_.lock();
            try {
                if (self_ == null) {
                    self_ = new ReadRepairManager();
                }
            }
            finally {
                lock_.unlock();
            }
        }
        return self_;
    }

    public void schedule(EndPoint target, RowMutationMessage rowMutationMessage) {
        try {
            Message message = rowMutationMessage.makeRowMutationMessage("READ-REPAIR-VERB-HANDLER");
            String key = target + ":" + message.getMessageId();
            this.readRepairTable_.put(key, message);
        }
        catch (IOException ex) {
            logger_.error((Object)LogUtil.throwableToString(ex));
        }
    }

    static class ReadRepairPerformer
    implements ICacheExpungeHook<String, Message> {
        ReadRepairPerformer() {
        }

        @Override
        public void callMe(String target, Message message) {
            String[] pieces = FBUtilities.strip(target, ":");
            EndPoint to = new EndPoint(pieces[0], Integer.parseInt(pieces[1]));
            MessagingService.getMessagingInstance().sendOneWay(message, to);
        }
    }
}

