/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.InvalidRequestException;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class QuorumResponseHandler<T>
implements IAsyncCallback {
    private static Logger logger_ = Logger.getLogger(QuorumResponseHandler.class);
    private Lock lock_ = new ReentrantLock();
    private Condition condition_;
    private int responseCount_;
    private List<Message> responses_ = new ArrayList<Message>();
    private IResponseResolver<T> responseResolver_;
    private AtomicBoolean done_ = new AtomicBoolean(false);
    private long startTime_;

    public QuorumResponseHandler(int responseCount, IResponseResolver<T> responseResolver) throws InvalidRequestException {
        if (responseCount > DatabaseDescriptor.getReplicationFactor()) {
            throw new InvalidRequestException("Cannot block for more than the replication factor of " + DatabaseDescriptor.getReplicationFactor());
        }
        if (responseCount < 1) {
            throw new InvalidRequestException("Cannot block for less than one replica");
        }
        this.condition_ = this.lock_.newCondition();
        this.responseCount_ = responseCount;
        this.responseResolver_ = responseResolver;
        this.startTime_ = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws TimeoutException, DigestMismatchException {
        this.lock_.lock();
        try {
            boolean bVal;
            block9: {
                bVal = true;
                try {
                    if (!this.done_.get()) {
                        long timeout = System.currentTimeMillis() - this.startTime_ + DatabaseDescriptor.getRpcTimeout();
                        bVal = timeout > 0L ? this.condition_.await(timeout, TimeUnit.MILLISECONDS) : false;
                    }
                }
                catch (InterruptedException ex) {
                    if (!logger_.isDebugEnabled()) break block9;
                    logger_.debug((Object)LogUtil.throwableToString(ex));
                }
            }
            if (!bVal && !this.done_.get()) {
                StringBuilder sb = new StringBuilder("");
                for (Message message : this.responses_) {
                    sb.append(message.getFrom());
                }
                throw new TimeoutException("Operation timed out - received only " + this.responses_.size() + " responses from " + sb.toString() + " .");
            }
        }
        finally {
            this.lock_.unlock();
            for (Message response : this.responses_) {
                MessagingService.removeRegisteredCallback(response.getMessageId());
            }
        }
        return this.responseResolver_.resolve(this.responses_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(Message message) {
        this.lock_.lock();
        try {
            if (!this.done_.get()) {
                this.responses_.add(message);
                if (this.responses_.size() >= this.responseCount_ && this.responseResolver_.isDataPresent(this.responses_)) {
                    this.done_.set(true);
                    this.condition_.signal();
                }
            }
        }
        finally {
            this.lock_.unlock();
        }
    }

    @Override
    public void attachContext(Object o) {
        throw new UnsupportedOperationException("This operation is not supported in this version of the callback handler");
    }
}

