/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.Comparator;
import org.apache.cassandra.utils.FileUtils;

class LoadInfo {
    private String diskSpace_;

    LoadInfo(long diskSpace) {
        this.diskSpace_ = FileUtils.stringifyFileSize(diskSpace);
    }

    LoadInfo(String loadInfo) {
        this.diskSpace_ = loadInfo;
    }

    String diskSpace() {
        return this.diskSpace_;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append(this.diskSpace_);
        return sb.toString();
    }

    protected static class DiskSpaceComparator
    implements Comparator<LoadInfo> {
        protected DiskSpaceComparator() {
        }

        @Override
        public int compare(LoadInfo li, LoadInfo li2) {
            if (li == null || li2 == null) {
                throw new IllegalArgumentException("Cannot pass in values that are NULL.");
            }
            double space = FileUtils.stringToFileSize(li.diskSpace_);
            double space2 = FileUtils.stringToFileSize(li2.diskSpace_);
            return (int)(space - space2);
        }
    }
}

