/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.io.ProtocolHeaderState;
import org.apache.cassandra.net.io.ReadNotCompleteException;
import org.apache.cassandra.net.io.StartState;
import org.apache.cassandra.net.io.TcpReader;

public class ProtocolState
extends StartState {
    private ByteBuffer buffer_ = ByteBuffer.allocate(16);

    public ProtocolState(TcpReader stream) {
        super(stream);
    }

    @Override
    public byte[] read() throws IOException, ReadNotCompleteException {
        return this.doRead(this.buffer_);
    }

    @Override
    public void morphState() throws IOException {
        StartState nextState;
        byte[] protocol = this.buffer_.array();
        if (MessagingService.isProtocolValid(protocol)) {
            nextState = this.stream_.getSocketState(TcpReader.TcpReaderState.PROTOCOL);
            if (nextState == null) {
                nextState = new ProtocolHeaderState(this.stream_);
                this.stream_.putSocketState(TcpReader.TcpReaderState.PROTOCOL, nextState);
            }
        } else {
            throw new IOException("Invalid protocol header. The preamble seems to be messed up.");
        }
        this.stream_.morphState(nextState);
        this.buffer_.clear();
    }

    @Override
    public void setContextData(Object data) {
        throw new UnsupportedOperationException("This method is not supported in the ProtocolState");
    }
}

