/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.CompactEndPointSerializationHelper;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Header;

class HeaderSerializer
implements ICompactSerializer<Header> {
    HeaderSerializer() {
    }

    @Override
    public void serialize(Header t, DataOutputStream dos) throws IOException {
        dos.writeUTF(t.getMessageId());
        CompactEndPointSerializationHelper.serialize(t.getFrom(), dos);
        dos.writeUTF(t.getMessageType());
        dos.writeUTF(t.getVerb());
        int size = t.details_.size();
        dos.writeInt(size);
        Set<String> keys = t.details_.keySet();
        for (String key : keys) {
            dos.writeUTF(key);
            byte[] value = t.details_.get(key);
            dos.writeInt(value.length);
            dos.write(value);
        }
    }

    @Override
    public Header deserialize(DataInputStream dis) throws IOException {
        String id = dis.readUTF();
        EndPoint from = CompactEndPointSerializationHelper.deserialize(dis);
        String type = dis.readUTF();
        String verb = dis.readUTF();
        int size = dis.readInt();
        Hashtable<String, byte[]> details = new Hashtable<String, byte[]>(size);
        for (int i = 0; i < size; ++i) {
            String key = dis.readUTF();
            int length = dis.readInt();
            byte[] bytes = new byte[length];
            dis.readFully(bytes);
            details.put(key, bytes);
        }
        return new Header(id, from, type, verb, details);
    }
}

