/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.HeaderSerializer;

public class Header
implements Serializable {
    static final long serialVersionUID = -3194851946523170022L;
    private static ICompactSerializer<Header> serializer_;
    private static AtomicInteger idGen_;
    private EndPoint from_;
    private String type_;
    private String verb_;
    private String messageId_;
    protected Map<String, byte[]> details_ = new Hashtable<String, byte[]>();

    static ICompactSerializer<Header> serializer() {
        return serializer_;
    }

    Header(String id, EndPoint from, String messageType, String verb) {
        this.messageId_ = id;
        this.from_ = from;
        this.type_ = messageType;
        this.verb_ = verb;
    }

    Header(String id, EndPoint from, String messageType, String verb, Map<String, byte[]> details) {
        this(id, from, messageType, verb);
        this.details_ = details;
    }

    Header(EndPoint from, String messageType, String verb) {
        this.messageId_ = Integer.toString(idGen_.incrementAndGet());
        this.from_ = from;
        this.type_ = messageType;
        this.verb_ = verb;
    }

    EndPoint getFrom() {
        return this.from_;
    }

    String getMessageType() {
        return this.type_;
    }

    String getVerb() {
        return this.verb_;
    }

    String getMessageId() {
        return this.messageId_;
    }

    void setMessageId(String id) {
        this.messageId_ = id;
    }

    void setMessageType(String type) {
        this.type_ = type;
    }

    void setMessageVerb(String verb) {
        this.verb_ = verb;
    }

    byte[] getDetail(Object key) {
        return this.details_.get(key);
    }

    void removeDetail(Object key) {
        this.details_.remove(key);
    }

    void addDetail(String key, byte[] value) {
        this.details_.put(key, value);
    }

    Map<String, byte[]> getDetails() {
        return this.details_;
    }

    static {
        idGen_ = new AtomicInteger(0);
        serializer_ = new HeaderSerializer();
    }
}

