/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.LogUtil;

public class RackAwareStrategy
extends AbstractReplicationStrategy {
    public RackAwareStrategy(TokenMetadata tokenMetadata, IPartitioner partitioner, int replicas, int storagePort) {
        super(tokenMetadata, partitioner, replicas, storagePort);
    }

    @Override
    public EndPoint[] getReadStorageEndPoints(Token token) {
        int count;
        ArrayList<EndPoint> list = new ArrayList<EndPoint>();
        boolean bDataCenter = false;
        boolean bOtherRack = false;
        int foundCount = 0;
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        ArrayList<Token> tokens = new ArrayList<Token>(tokenToEndPointMap.keySet());
        Collections.sort(tokens);
        int index = Collections.binarySearch(tokens, token);
        if (index < 0 && (index = (index + 1) * -1) >= tokens.size()) {
            index = 0;
        }
        int totalNodes = tokens.size();
        list.add(tokenToEndPointMap.get(tokens.get(index)));
        ++foundCount;
        if (this.replicas_ == 1) {
            return list.toArray(new EndPoint[list.size()]);
        }
        int startIndex = (index + 1) % totalNodes;
        IEndPointSnitch endPointSnitch = StorageService.instance().getEndPointSnitch();
        int i = startIndex;
        for (count = 1; count < totalNodes && foundCount < this.replicas_; ++count) {
            block11: {
                try {
                    if (!endPointSnitch.isInSameDataCenter(tokenToEndPointMap.get(tokens.get(index)), tokenToEndPointMap.get(tokens.get(i)))) {
                        if (!bDataCenter) {
                            list.add(tokenToEndPointMap.get(tokens.get(i)));
                            bDataCenter = true;
                            ++foundCount;
                        }
                    } else if (!endPointSnitch.isOnSameRack(tokenToEndPointMap.get(tokens.get(index)), tokenToEndPointMap.get(tokens.get(i))) && endPointSnitch.isInSameDataCenter(tokenToEndPointMap.get(tokens.get(index)), tokenToEndPointMap.get(tokens.get(i))) && !bOtherRack) {
                        list.add(tokenToEndPointMap.get(tokens.get(i)));
                        bOtherRack = true;
                        ++foundCount;
                    }
                }
                catch (UnknownHostException e) {
                    if (!logger_.isDebugEnabled()) break block11;
                    logger_.debug((Object)LogUtil.throwableToString(e));
                }
            }
            i = (i + 1) % totalNodes;
        }
        i = startIndex;
        for (count = 1; count < totalNodes && foundCount < this.replicas_; ++count) {
            if (!list.contains(tokenToEndPointMap.get(tokens.get(i)))) {
                list.add(tokenToEndPointMap.get(tokens.get(i)));
                ++foundCount;
            }
            i = (i + 1) % totalNodes;
        }
        this.retrofitPorts(list);
        return list.toArray(new EndPoint[list.size()]);
    }

    @Override
    public EndPoint[] getReadStorageEndPoints(Token token, Map<Token, EndPoint> tokenToEndPointMap) {
        throw new UnsupportedOperationException("This operation is not currently supported");
    }

    @Override
    public EndPoint[] getWriteStorageEndPoints(Token token) {
        throw new UnsupportedOperationException("Rack-aware bootstrapping not supported");
    }

    public Map<EndPoint, EndPoint> getHintedStorageEndPointsForWrite(Token token) {
        throw new UnsupportedOperationException("Rack-aware bootstrapping not supported");
    }
}

