/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.utils.BloomFilter;

public class IndexHelper {
    public static int skipBloomFilterAndIndex(DataInput in) throws IOException {
        return IndexHelper.skipBloomFilter(in) + IndexHelper.skipIndex(in);
    }

    public static int skipBloomFilter(DataInput in) throws IOException {
        int totalBytesRead = 0;
        int size = in.readInt();
        totalBytesRead += 4;
        if (in.skipBytes(size) != size) {
            throw new EOFException();
        }
        return totalBytesRead += size;
    }

    private static int skipIndex(DataInput file) throws IOException {
        int columnIndexSize = file.readInt();
        int totalBytesRead = 4;
        if (file.skipBytes(columnIndexSize) != columnIndexSize) {
            throw new EOFException();
        }
        return totalBytesRead += columnIndexSize;
    }

    public static ArrayList<IndexInfo> deserializeIndex(RandomAccessFile in) throws IOException {
        ArrayList<IndexInfo> indexList = new ArrayList<IndexInfo>();
        int columnIndexSize = in.readInt();
        long start = in.getFilePointer();
        while (in.getFilePointer() < start + (long)columnIndexSize) {
            indexList.add(IndexInfo.deserialize(in));
        }
        assert (in.getFilePointer() == start + (long)columnIndexSize);
        return indexList;
    }

    public static BloomFilter defreezeBloomFilter(RandomAccessFile file) throws IOException {
        int size = file.readInt();
        byte[] bytes = new byte[size];
        file.readFully(bytes);
        DataInputBuffer bufIn = new DataInputBuffer();
        bufIn.reset(bytes, bytes.length);
        return BloomFilter.serializer().deserialize(bufIn);
    }

    public static int indexFor(byte[] name, List<IndexInfo> indexList, AbstractType comparator, boolean reversed) {
        if (name.length == 0 && reversed) {
            return indexList.size() - 1;
        }
        IndexInfo target = new IndexInfo(name, name, 0L, 0L);
        int index = Collections.binarySearch(indexList, target, IndexHelper.getComparator(comparator));
        return index < 0 ? -1 * (index + 1) : index;
    }

    public static Comparator<IndexInfo> getComparator(final AbstractType nameComparator) {
        return new Comparator<IndexInfo>(){

            @Override
            public int compare(IndexInfo o1, IndexInfo o2) {
                return nameComparator.compare(o1.lastName, o2.lastName);
            }
        };
    }

    public static class IndexInfo {
        public final long width;
        public final byte[] lastName;
        public final byte[] firstName;
        public final long offset;

        public IndexInfo(byte[] firstName, byte[] lastName, long offset, long width) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.offset = offset;
            this.width = width;
        }

        public void serialize(DataOutput dos) throws IOException {
            ColumnSerializer.writeName(this.firstName, dos);
            ColumnSerializer.writeName(this.lastName, dos);
            dos.writeLong(this.offset);
            dos.writeLong(this.width);
        }

        public int serializedSize() {
            return 2 + this.firstName.length + 2 + this.lastName.length + 8 + 8;
        }

        public static IndexInfo deserialize(RandomAccessFile dis) throws IOException {
            return new IndexInfo(ColumnSerializer.readName(dis), ColumnSerializer.readName(dis), dis.readLong(), dis.readLong());
        }
    }
}

