/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.gms.HeartBeatStateSerializer;
import org.apache.cassandra.gms.VersionGenerator;
import org.apache.cassandra.io.ICompactSerializer;

class HeartBeatState {
    private static ICompactSerializer<HeartBeatState> serializer_ = new HeartBeatStateSerializer();
    int generation_;
    AtomicInteger heartbeat_;
    int version_;

    HeartBeatState() {
    }

    HeartBeatState(int generation, int heartbeat) {
        this(generation, heartbeat, 0);
    }

    HeartBeatState(int generation, int heartbeat, int version) {
        this.generation_ = generation;
        this.heartbeat_ = new AtomicInteger(heartbeat);
        this.version_ = version;
    }

    public static ICompactSerializer<HeartBeatState> serializer() {
        return serializer_;
    }

    int getGeneration() {
        return this.generation_;
    }

    void updateGeneration() {
        ++this.generation_;
        this.version_ = VersionGenerator.getNextVersion();
    }

    int getHeartBeat() {
        return this.heartbeat_.get();
    }

    void updateHeartBeat() {
        this.heartbeat_.incrementAndGet();
        this.version_ = VersionGenerator.getNextVersion();
    }

    int getHeartBeatVersion() {
        return this.version_;
    }
}

