/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.log4j.Logger;

class GossipDigestSerializationHelper {
    private static Logger logger_ = Logger.getLogger(GossipDigestSerializationHelper.class);

    GossipDigestSerializationHelper() {
    }

    static boolean serialize(List<GossipDigest> gDigestList, DataOutputStream dos) throws IOException {
        boolean bVal = true;
        int size = gDigestList.size();
        dos.writeInt(size);
        int estimate = 0;
        for (GossipDigest gDigest : gDigestList) {
            if (1428 - dos.size() < estimate) {
                logger_.info((Object)"@@@@ Breaking out to respect the MTU size in GD @@@@");
                bVal = false;
                break;
            }
            int pre = dos.size();
            GossipDigest.serializer().serialize(gDigest, dos);
            int post = dos.size();
            estimate = post - pre;
        }
        return bVal;
    }

    static List<GossipDigest> deserialize(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>();
        for (int i = 0; i < size; ++i) {
            if (dis.available() == 0) {
                logger_.info((Object)"Remaining bytes zero. Stopping deserialization of GossipDigests.");
                break;
            }
            GossipDigest gDigest = GossipDigest.serializer().deserialize(dis);
            gDigests.add(gDigest);
        }
        return gDigests;
    }
}

