/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck2Message;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.log4j.Logger;

class GossipDigestAckVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(GossipDigestAckVerbHandler.class);

    GossipDigestAckVerbHandler() {
    }

    @Override
    public void doVerb(Message message) {
        EndPoint from = message.getFrom();
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Received a GossipDigestAckMessage from " + from));
        }
        byte[] bytes = message.getMessageBody();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            GossipDigestAckMessage gDigestAckMessage = GossipDigestAckMessage.serializer().deserialize(dis);
            List<GossipDigest> gDigestList = gDigestAckMessage.getGossipDigestList();
            Map<EndPoint, EndPointState> epStateMap = gDigestAckMessage.getEndPointStateMap();
            if (epStateMap.size() > 0) {
                Gossiper.instance().notifyFailureDetector(epStateMap);
                Gossiper.instance().applyStateLocally(epStateMap);
            }
            HashMap<EndPoint, EndPointState> deltaEpStateMap = new HashMap<EndPoint, EndPointState>();
            for (GossipDigest gDigest : gDigestList) {
                EndPoint addr = gDigest.getEndPoint();
                EndPointState localEpStatePtr = Gossiper.instance().getStateForVersionBiggerThan(addr, gDigest.getMaxVersion());
                if (localEpStatePtr == null) continue;
                deltaEpStateMap.put(addr, localEpStatePtr);
            }
            GossipDigestAck2Message gDigestAck2 = new GossipDigestAck2Message(deltaEpStateMap);
            Message gDigestAck2Message = Gossiper.instance().makeGossipDigestAck2Message(gDigestAck2);
            if (logger_.isTraceEnabled()) {
                logger_.trace((Object)("Sending a GossipDigestAck2Message to " + from));
            }
            MessagingService.getMessagingInstance().sendUdpOneWay(gDigestAck2Message, from);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

