/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.GossipDigestAck2Message;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.log4j.Logger;

class GossipDigestAck2VerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(GossipDigestAck2VerbHandler.class);

    GossipDigestAck2VerbHandler() {
    }

    @Override
    public void doVerb(Message message) {
        EndPoint from = message.getFrom();
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Received a GossipDigestAck2Message from " + from));
        }
        byte[] bytes = message.getMessageBody();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        GossipDigestAck2Message gDigestAck2Message = null;
        try {
            gDigestAck2Message = GossipDigestAck2Message.serializer().deserialize(dis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<EndPoint, EndPointState> remoteEpStateMap = gDigestAck2Message.getEndPointStateMap();
        Gossiper.instance().notifyFailureDetector(remoteEpStateMap);
        Gossiper.instance().applyStateLocally(remoteEpStateMap);
    }
}

