/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.FileOutputStream;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ArrivalWindow;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.FailureDetectorMBean;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class FailureDetector
implements IFailureDetector,
FailureDetectorMBean {
    private static Logger logger_ = Logger.getLogger(FailureDetector.class);
    private static final int sampleSize_ = 1000;
    private static final int phiSuspectThreshold_ = 5;
    private static final int phiConvictThreshold_ = 8;
    private static final long uptimeThreshold_ = 60000L;
    private static IFailureDetector failureDetector_;
    private static Lock createLock_;
    private static long creationTime_;
    private Map<EndPoint, ArrivalWindow> arrivalSamples_ = new Hashtable<EndPoint, ArrivalWindow>();
    private List<IFailureDetectionEventListener> fdEvntListeners_ = new ArrayList<IFailureDetectionEventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFailureDetector instance() {
        if (failureDetector_ == null) {
            createLock_.lock();
            try {
                if (failureDetector_ == null) {
                    failureDetector_ = new FailureDetector();
                }
            }
            finally {
                createLock_.unlock();
            }
        }
        return failureDetector_;
    }

    public FailureDetector() {
        creationTime_ = System.currentTimeMillis();
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.gms:type=FailureDetector"));
        }
        catch (Exception e) {
            logger_.error((Object)LogUtil.throwableToString(e));
        }
    }

    @Override
    public void dumpInterArrivalTimes() {
        try {
            FileOutputStream fos = new FileOutputStream("/var/tmp/output-" + System.currentTimeMillis() + ".dat", true);
            fos.write(this.toString().getBytes());
            fos.close();
        }
        catch (Throwable th) {
            logger_.warn((Object)LogUtil.throwableToString(th));
        }
    }

    private void dumpInterArrivalTimes(EndPoint ep) {
        long now = System.currentTimeMillis();
        if (now - creationTime_ <= 60000L) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream("/var/tmp/output-" + System.currentTimeMillis() + "-" + ep + ".dat", true);
            ArrivalWindow hWnd = this.arrivalSamples_.get(ep);
            fos.write(hWnd.toString().getBytes());
            fos.close();
        }
        catch (Throwable th) {
            logger_.warn((Object)LogUtil.throwableToString(th));
        }
    }

    @Override
    public boolean isAlive(EndPoint ep) {
        try {
            String localHost = FBUtilities.getHostAddress();
            if (localHost.equals(ep.getHost())) {
                return true;
            }
        }
        catch (UnknownHostException ex) {
            logger_.info((Object)LogUtil.throwableToString(ex));
        }
        EndPoint ep2 = new EndPoint(ep.getHost(), DatabaseDescriptor.getControlPort());
        EndPointState epState = Gossiper.instance().getEndPointStateForEndPoint(ep2);
        return epState.isAlive();
    }

    @Override
    public void report(EndPoint ep) {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("reporting " + ep));
        }
        long now = System.currentTimeMillis();
        ArrivalWindow heartbeatWindow = this.arrivalSamples_.get(ep);
        if (heartbeatWindow == null) {
            heartbeatWindow = new ArrivalWindow(1000);
            this.arrivalSamples_.put(ep, heartbeatWindow);
        }
        heartbeatWindow.add(now);
    }

    @Override
    public void interpret(EndPoint ep) {
        ArrivalWindow hbWnd = this.arrivalSamples_.get(ep);
        if (hbWnd == null) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean isConvicted = false;
        double phi = hbWnd.phi(now);
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("PHI for " + ep + " : " + phi));
        }
        if (!isConvicted && phi > 5.0) {
            for (IFailureDetectionEventListener listener : this.fdEvntListeners_) {
                listener.suspect(ep);
            }
        }
    }

    @Override
    public void registerFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners_.add(listener);
    }

    @Override
    public void unregisterFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners_.remove(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<EndPoint> eps = this.arrivalSamples_.keySet();
        sb.append("-----------------------------------------------------------------------");
        for (EndPoint ep : eps) {
            ArrivalWindow hWnd = this.arrivalSamples_.get(ep);
            sb.append(ep + " : ");
            sb.append(hWnd.toString());
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("-----------------------------------------------------------------------");
        return sb.toString();
    }

    public static void main(String[] args) throws Throwable {
    }

    static {
        createLock_ = new ReentrantLock();
    }
}

