/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.Serializable;
import java.util.List;
import org.apache.cassandra.dht.RangeSerializer;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.ICompactSerializer;

public class Range
implements Comparable<Range>,
Serializable {
    private static ICompactSerializer<Range> serializer_ = new RangeSerializer();
    private final Token left_;
    private final Token right_;

    public static ICompactSerializer<Range> serializer() {
        return serializer_;
    }

    public Range(Token left, Token right) {
        this.left_ = left;
        this.right_ = right;
    }

    public Token left() {
        return this.left_;
    }

    public Token right() {
        return this.right_;
    }

    public boolean contains(Token bi) {
        if (this.left_.compareTo(this.right_) > 0) {
            if (bi.compareTo(this.left_) >= 0) {
                return true;
            }
            return this.right_.compareTo(bi) > 0;
        }
        if (this.left_.compareTo(this.right_) < 0) {
            return bi.compareTo(this.left_) >= 0 && this.right_.compareTo(bi) > 0;
        }
        return true;
    }

    private static boolean isWrapAround(Range range) {
        return range.left_.compareTo(range.right_) > 0;
    }

    @Override
    public int compareTo(Range rhs) {
        if (Range.isWrapAround(this)) {
            return -1;
        }
        if (Range.isWrapAround(rhs)) {
            return 1;
        }
        return this.right_.compareTo(rhs.right_);
    }

    public static boolean isTokenInRanges(Token token, List<Range> ranges) {
        assert (ranges != null);
        for (Range range : ranges) {
            if (!range.contains(token)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Range)) {
            return false;
        }
        Range rhs = (Range)o;
        return this.left_.equals(rhs.left_) && this.right_.equals(rhs.right_);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "(" + this.left_ + "," + this.right_ + "]";
    }
}

