/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.StringToken;
import org.apache.cassandra.dht.Token;

public class OrderPreservingPartitioner
implements IPartitioner<StringToken> {
    public static final StringToken MINIMUM = new StringToken("");
    private static final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    private static final Comparator<String> reverseComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o2.compareTo(o1);
        }
    };
    private final Token.TokenFactory<String> tokenFactory = new Token.TokenFactory<String>(){

        @Override
        public byte[] toByteArray(Token<String> stringToken) {
            try {
                return ((String)stringToken.token).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Token<String> fromByteArray(byte[] bytes) {
            try {
                return new StringToken(new String(bytes, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString(Token<String> stringToken) {
            return (String)stringToken.token;
        }

        @Override
        public Token<String> fromString(String string) {
            return new StringToken(string);
        }
    };

    @Override
    public String decorateKey(String key) {
        return key;
    }

    @Override
    public String undecorateKey(String decoratedKey) {
        return decoratedKey;
    }

    @Override
    public Comparator<String> getDecoratedKeyComparator() {
        return comparator;
    }

    @Override
    public Comparator<String> getReverseDecoratedKeyComparator() {
        return reverseComparator;
    }

    private static char[] getChars(String str, int length) {
        char[] chars;
        if (str.length() < length) {
            chars = new char[length];
            str.getChars(0, str.length(), chars, 0);
        } else if (str.length() == length) {
            chars = str.toCharArray();
        } else {
            throw new RuntimeException("Cannot truncate string of length " + str.length() + " to length " + length);
        }
        return chars;
    }

    private static String midpoint(String left, String right) {
        int i;
        char[] rchars;
        char[] lchars;
        int inlength;
        int comparison = left.compareTo(right);
        if (comparison < 0) {
            inlength = Math.max(left.length(), right.length());
            lchars = OrderPreservingPartitioner.getChars(left, inlength);
            rchars = OrderPreservingPartitioner.getChars(right, inlength);
        } else {
            assert (((String)OrderPreservingPartitioner.MINIMUM.token).equals(right));
            inlength = Math.max(left.length(), 1);
            lchars = OrderPreservingPartitioner.getChars(left, inlength);
            rchars = new char[inlength];
            Arrays.fill(rchars, '\uffff');
        }
        int outlength = (lchars[inlength - 1] & '\u0001') == (rchars[inlength - 1] & '\u0001') ? inlength : inlength + 1;
        char[] result = new char[outlength];
        boolean carrying = false;
        for (i = inlength - 1; i >= 0; --i) {
            int sum = carrying ? 1 : 0;
            carrying = (sum += (lchars[i] & 0xFFFF) + (rchars[i] & 0xFFFF)) > 65535;
            result[i] = (char)sum;
        }
        for (i = 0; i < inlength; ++i) {
            char shifted = (char)(carrying ? 32768 : 0);
            carrying = (result[i] & '\u0001') == 1;
            result[i] = (char)(shifted | (result[i] & 0xFFFF) >>> 1);
        }
        if (carrying) {
            int n = inlength;
            result[n] = (char)(result[n] | 0x8000);
        }
        return new String(result);
    }

    @Override
    public StringToken midpoint(StringToken ltoken, StringToken rtoken) {
        return new StringToken(OrderPreservingPartitioner.midpoint((String)ltoken.token, (String)rtoken.token));
    }

    @Override
    public StringToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public StringToken getDefaultToken() {
        String initialToken = DatabaseDescriptor.getInitialToken();
        if (initialToken != null) {
            return new StringToken(initialToken);
        }
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random r = new Random();
        StringBuilder buffer = new StringBuilder();
        for (int j = 0; j < 16; ++j) {
            buffer.append(chars.charAt(r.nextInt(chars.length())));
        }
        return new StringToken(buffer.toString());
    }

    @Override
    public Token.TokenFactory<String> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public StringToken getToken(String key) {
        return new StringToken(key);
    }
}

