/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.dht.BootstrapInitiateMessage;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.io.StreamContextManager;

class BootstrapInitiateMessageSerializer
implements ICompactSerializer<BootstrapInitiateMessage> {
    BootstrapInitiateMessageSerializer() {
    }

    @Override
    public void serialize(BootstrapInitiateMessage bim, DataOutputStream dos) throws IOException {
        dos.writeInt(bim.streamContexts_.length);
        for (StreamContextManager.StreamContext streamContext : bim.streamContexts_) {
            StreamContextManager.StreamContext.serializer().serialize(streamContext, dos);
        }
    }

    @Override
    public BootstrapInitiateMessage deserialize(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        StreamContextManager.StreamContext[] streamContexts = new StreamContextManager.StreamContext[]{};
        if (size > 0) {
            streamContexts = new StreamContextManager.StreamContext[size];
            for (int i = 0; i < size; ++i) {
                streamContexts[i] = StreamContextManager.StreamContext.serializer().deserialize(dis);
            }
        }
        return new BootstrapInitiateMessage(streamContexts);
    }
}

