/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;

public class LexicalUUIDType
extends AbstractType {
    static UUID getUUID(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        return new UUID(bb.getLong(), bb.getLong());
    }

    @Override
    public int compare(byte[] o1, byte[] o2) {
        if (o1.length == 0) {
            return o2.length == 0 ? 0 : -1;
        }
        if (o2.length == 0) {
            return 1;
        }
        return LexicalUUIDType.getUUID(o1).compareTo(LexicalUUIDType.getUUID(o2));
    }

    @Override
    public String getString(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        if (bytes.length != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        return LexicalUUIDType.getUUID(bytes).toString();
    }
}

