/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.BufferedRandomAccessFile;
import org.apache.cassandra.io.IndexHelper;
import org.apache.cassandra.io.SSTableReader;

class SSTableSliceIterator
extends AbstractIterator<IColumn>
implements ColumnIterator {
    private final boolean reversed;
    private final byte[] startColumn;
    private final AbstractType comparator;
    private ColumnGroupReader reader;

    public SSTableSliceIterator(SSTableReader ssTable, String key, byte[] startColumn, boolean reversed) throws IOException {
        this.reversed = reversed;
        String decoratedKey = ssTable.getPartitioner().decorateKey(key);
        long position = ssTable.getPosition(decoratedKey);
        this.comparator = ssTable.getColumnComparator();
        this.startColumn = startColumn;
        if (position >= 0L) {
            this.reader = new ColumnGroupReader(ssTable, decoratedKey, position);
        }
    }

    private boolean isColumnNeeded(IColumn column) {
        return this.reversed ? this.startColumn.length == 0 || this.comparator.compare(column.name(), this.startColumn) <= 0 : this.comparator.compare(column.name(), this.startColumn) >= 0;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.reader.getEmptyColumnFamily();
    }

    protected IColumn computeNext() {
        IColumn column;
        if (this.reader == null) {
            return (IColumn)this.endOfData();
        }
        do {
            if ((column = this.reader.pollColumn()) != null) continue;
            return (IColumn)this.endOfData();
        } while (!this.isColumnNeeded(column));
        return column;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    class ColumnGroupReader {
        private final ColumnFamily emptyColumnFamily;
        private final List<IndexHelper.IndexInfo> indexes;
        private final long columnStartPosition;
        private final BufferedRandomAccessFile file;
        private int curRangeIndex;
        private Deque<IColumn> blockColumns = new ArrayDeque<IColumn>();

        public ColumnGroupReader(SSTableReader ssTable, String key, long position) throws IOException {
            this.file = new BufferedRandomAccessFile(ssTable.getFilename(), "r", DatabaseDescriptor.getSlicedReadBufferSizeInKB() * 1024);
            this.file.seek(position);
            String keyInDisk = this.file.readUTF();
            assert (keyInDisk.equals(key));
            this.file.readInt();
            IndexHelper.skipBloomFilter(this.file);
            this.indexes = IndexHelper.deserializeIndex(this.file);
            this.emptyColumnFamily = ColumnFamily.serializer().deserializeFromSSTableNoColumns(ssTable.makeColumnFamily(), this.file);
            this.file.readInt();
            this.columnStartPosition = this.file.getFilePointer();
            this.curRangeIndex = IndexHelper.indexFor(SSTableSliceIterator.this.startColumn, this.indexes, SSTableSliceIterator.this.comparator, SSTableSliceIterator.this.reversed);
            if (SSTableSliceIterator.this.reversed && this.curRangeIndex == this.indexes.size()) {
                --this.curRangeIndex;
            }
        }

        public ColumnFamily getEmptyColumnFamily() {
            return this.emptyColumnFamily;
        }

        public IColumn pollColumn() {
            IColumn column = this.blockColumns.poll();
            if (column == null) {
                try {
                    if (this.getNextBlock()) {
                        column = this.blockColumns.poll();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return column;
        }

        public boolean getNextBlock() throws IOException {
            if (this.curRangeIndex < 0 || this.curRangeIndex >= this.indexes.size()) {
                return false;
            }
            IndexHelper.IndexInfo curColPostion = this.indexes.get(this.curRangeIndex);
            this.file.seek(this.columnStartPosition + curColPostion.offset);
            while (this.file.getFilePointer() < this.columnStartPosition + curColPostion.offset + curColPostion.width) {
                IColumn column = this.emptyColumnFamily.getColumnSerializer().deserialize(this.file);
                if (SSTableSliceIterator.this.reversed) {
                    this.blockColumns.addFirst(column);
                    continue;
                }
                this.blockColumns.addLast(column);
            }
            this.curRangeIndex = SSTableSliceIterator.this.reversed ? --this.curRangeIndex : ++this.curRangeIndex;
            return true;
        }

        public void close() throws IOException {
            this.file.close();
        }
    }
}

