/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.SuperColumnSerializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.log4j.Logger;

public final class SuperColumn
implements IColumn,
IColumnContainer {
    private static Logger logger_ = Logger.getLogger(SuperColumn.class);
    private byte[] name_;
    private ConcurrentSkipListMap<byte[], IColumn> columns_;
    private int localDeletionTime = Integer.MIN_VALUE;
    private long markedForDeleteAt = Long.MIN_VALUE;
    private AtomicInteger size_ = new AtomicInteger(0);

    static SuperColumnSerializer serializer(AbstractType comparator) {
        return new SuperColumnSerializer(comparator);
    }

    SuperColumn(byte[] name, AbstractType comparator) {
        assert (name != null);
        assert (name.length <= 65535);
        this.name_ = name;
        this.columns_ = new ConcurrentSkipListMap(comparator);
    }

    @Override
    public AbstractType getComparator() {
        return (AbstractType)this.columns_.comparator();
    }

    public SuperColumn cloneMeShallow() {
        SuperColumn sc = new SuperColumn(this.name_, this.getComparator());
        sc.markForDeleteAt(this.localDeletionTime, this.markedForDeleteAt);
        return sc;
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.markedForDeleteAt > Long.MIN_VALUE;
    }

    @Override
    public byte[] name() {
        return this.name_;
    }

    @Override
    public Collection<IColumn> getSubColumns() {
        return this.columns_.values();
    }

    @Override
    public IColumn getSubColumn(byte[] columnName) {
        IColumn column = this.columns_.get(columnName);
        assert (column == null || column instanceof Column);
        return column;
    }

    @Override
    public int size() {
        return this.size_.get();
    }

    @Override
    public int serializedSize() {
        return 2 + this.name_.length + 4 + 8 + 4 + this.getSizeOfAllColumns();
    }

    int getSizeOfAllColumns() {
        int size = 0;
        for (IColumn subColumn : this.getSubColumns()) {
            size += subColumn.serializedSize();
        }
        return size;
    }

    public void remove(byte[] columnName) {
        this.columns_.remove(columnName);
    }

    @Override
    public long timestamp() {
        throw new UnsupportedOperationException("This operation is not supported for Super Columns.");
    }

    @Override
    public long timestamp(byte[] columnName) {
        IColumn column = this.columns_.get(columnName);
        assert (column instanceof Column);
        if (column != null) {
            return column.timestamp();
        }
        throw new IllegalArgumentException("Timestamp was requested for a column that does not exist.");
    }

    @Override
    public long mostRecentChangeAt() {
        long max = Long.MIN_VALUE;
        for (IColumn column : this.columns_.values()) {
            if (column.mostRecentChangeAt() <= max) continue;
            max = column.mostRecentChangeAt();
        }
        return max;
    }

    @Override
    public byte[] value() {
        throw new UnsupportedOperationException("This operation is not supported for Super Columns.");
    }

    @Override
    public byte[] value(byte[] columnName) {
        IColumn column = this.columns_.get(columnName);
        if (column != null) {
            return column.value();
        }
        throw new IllegalArgumentException("Value was requested for a column that does not exist.");
    }

    @Override
    public void addColumn(IColumn column) {
        if (!(column instanceof Column)) {
            throw new UnsupportedOperationException("A super column can only contain simple columns.");
        }
        IColumn oldColumn = this.columns_.get(column.name());
        if (oldColumn == null) {
            this.columns_.put(column.name(), column);
            this.size_.addAndGet(column.size());
        } else if (((Column)oldColumn).comparePriority((Column)column) <= 0L) {
            this.columns_.put(column.name(), column);
            int delta = -1 * oldColumn.size();
            this.size_.addAndGet(delta);
            this.size_.addAndGet(column.size());
        }
    }

    public void putColumn(IColumn column) {
        if (!(column instanceof SuperColumn)) {
            throw new UnsupportedOperationException("Only Super column objects should be put here");
        }
        if (!Arrays.equals(this.name_, column.name())) {
            throw new IllegalArgumentException("The name should match the name of the current column or super column");
        }
        for (IColumn subColumn : column.getSubColumns()) {
            this.addColumn(subColumn);
        }
        if (column.getMarkedForDeleteAt() > this.markedForDeleteAt) {
            this.markForDeleteAt(column.getLocalDeletionTime(), column.getMarkedForDeleteAt());
        }
    }

    @Override
    public int getObjectCount() {
        return 1 + this.columns_.size();
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.markedForDeleteAt;
    }

    int getColumnCount() {
        return this.columns_.size();
    }

    @Override
    public IColumn diff(IColumn columnNew) {
        SuperColumn columnDiff = new SuperColumn(columnNew.name(), ((SuperColumn)columnNew).getComparator());
        if (columnNew.getMarkedForDeleteAt() > this.getMarkedForDeleteAt()) {
            columnDiff.markForDeleteAt(columnNew.getLocalDeletionTime(), columnNew.getMarkedForDeleteAt());
        }
        for (IColumn subColumn : columnNew.getSubColumns()) {
            IColumn columnInternal = this.columns_.get(subColumn.name());
            if (columnInternal == null) {
                columnDiff.addColumn(subColumn);
                continue;
            }
            IColumn subColumnDiff = columnInternal.diff(subColumn);
            if (subColumnDiff == null) continue;
            columnDiff.addColumn(subColumnDiff);
        }
        if (!columnDiff.getSubColumns().isEmpty() || columnNew.isMarkedForDelete()) {
            return columnDiff;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        assert (this.name_ != null);
        digest.update(this.name_);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.markedForDeleteAt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
        for (IColumn column : this.columns_.values()) {
            column.updateDigest(digest);
        }
    }

    @Override
    public String getString(AbstractType comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append("SuperColumn(");
        sb.append(comparator.getString(this.name_));
        if (this.isMarkedForDelete()) {
            sb.append(" -delete at ").append(this.getMarkedForDeleteAt()).append("-");
        }
        sb.append(" [");
        sb.append(this.getComparator().getColumnsString(this.columns_.values()));
        sb.append("])");
        return sb.toString();
    }

    @Override
    public int getLocalDeletionTime() {
        return this.localDeletionTime;
    }

    public void markForDeleteAt(int localDeleteTime, long timestamp) {
        this.localDeletionTime = localDeleteTime;
        this.markedForDeleteAt = timestamp;
    }
}

