/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.io.ICompactSerializer;

class RowMutationSerializer
implements ICompactSerializer<RowMutation> {
    RowMutationSerializer() {
    }

    private void freezeTheMaps(Map<String, ColumnFamily> map, DataOutputStream dos) throws IOException {
        int size = map.size();
        dos.writeInt(size);
        if (size > 0) {
            Set<String> keys = map.keySet();
            for (String key : keys) {
                dos.writeUTF(key);
                ColumnFamily cf = map.get(key);
                if (cf == null) continue;
                ColumnFamily.serializer().serialize(cf, (DataOutput)dos);
            }
        }
    }

    @Override
    public void serialize(RowMutation rm, DataOutputStream dos) throws IOException {
        dos.writeUTF(rm.table());
        dos.writeUTF(rm.key());
        this.freezeTheMaps(rm.modifications_, dos);
    }

    private Map<String, ColumnFamily> defreezeTheMaps(DataInputStream dis) throws IOException {
        HashMap<String, ColumnFamily> map = new HashMap<String, ColumnFamily>();
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            String key = dis.readUTF();
            ColumnFamily cf = ColumnFamily.serializer().deserialize(dis);
            map.put(key, cf);
        }
        return map;
    }

    @Override
    public RowMutation deserialize(DataInputStream dis) throws IOException {
        String table = dis.readUTF();
        String key = dis.readUTF();
        Map<String, ColumnFamily> modifications = this.defreezeTheMaps(dis);
        return new RowMutation(table, key, modifications);
    }
}

