/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutationSerializer;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.Column;
import org.apache.cassandra.service.ColumnOrSuperColumn;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class RowMutation
implements Serializable {
    private static ICompactSerializer<RowMutation> serializer_ = new RowMutationSerializer();
    public static final String HINT = "HINT";
    private String table_;
    private String key_;
    protected Map<String, ColumnFamily> modifications_ = new HashMap<String, ColumnFamily>();

    static ICompactSerializer<RowMutation> serializer() {
        return serializer_;
    }

    public RowMutation(String table, String key) {
        this.table_ = table;
        this.key_ = key;
    }

    public RowMutation(String table, Row row) {
        this.table_ = table;
        this.key_ = row.key();
        for (ColumnFamily cf : row.getColumnFamilies()) {
            this.add(cf);
        }
    }

    protected RowMutation(String table, String key, Map<String, ColumnFamily> modifications) {
        this.table_ = table;
        this.key_ = key;
        this.modifications_ = modifications;
    }

    public String table() {
        return this.table_;
    }

    public String key() {
        return this.key_;
    }

    public Set<String> columnFamilyNames() {
        return this.modifications_.keySet();
    }

    void addHints(String key, String host) throws IOException {
        QueryPath path = new QueryPath("HintsColumnFamily", key.getBytes("UTF-8"), host.getBytes("UTF-8"));
        this.add(path, ArrayUtils.EMPTY_BYTE_ARRAY, System.currentTimeMillis());
    }

    public void add(ColumnFamily columnFamily) {
        if (this.modifications_.containsKey(columnFamily.name())) {
            throw new IllegalArgumentException("ColumnFamily " + columnFamily.name() + " is already being modified");
        }
        this.modifications_.put(columnFamily.name(), columnFamily);
    }

    public void add(QueryPath path, byte[] value, long timestamp) {
        ColumnFamily columnFamily = this.modifications_.get(path.columnFamilyName);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, path.columnFamilyName);
        }
        columnFamily.addColumn(path, value, timestamp);
        this.modifications_.put(path.columnFamilyName, columnFamily);
    }

    public void delete(QueryPath path, long timestamp) {
        assert (path.columnFamilyName != null);
        String cfName = path.columnFamilyName;
        if (this.modifications_.containsKey(cfName)) {
            throw new IllegalArgumentException("ColumnFamily " + cfName + " is already being modified");
        }
        int localDeleteTime = (int)(System.currentTimeMillis() / 1000L);
        ColumnFamily columnFamily = this.modifications_.get(cfName);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, cfName);
        }
        if (path.superColumnName == null && path.columnName == null) {
            columnFamily.delete(localDeleteTime, timestamp);
        } else if (path.columnName == null) {
            SuperColumn sc = new SuperColumn(path.superColumnName, DatabaseDescriptor.getSubComparator(this.table_, cfName));
            sc.markForDeleteAt(localDeleteTime, timestamp);
            columnFamily.addColumn(sc);
        } else {
            ByteBuffer bytes = ByteBuffer.allocate(4);
            bytes.putInt(localDeleteTime);
            columnFamily.addColumn(path, bytes.array(), timestamp, true);
        }
        this.modifications_.put(cfName, columnFamily);
    }

    public void apply() throws IOException {
        Row row = new Row(this.table_, this.key_);
        this.apply(row);
    }

    void apply(Row emptyRow) throws IOException {
        assert (emptyRow.getColumnFamilies().size() == 0);
        Table table = Table.open(this.table_);
        for (String cfName : this.modifications_.keySet()) {
            assert (table.isValidColumnFamily(cfName));
            emptyRow.addColumnFamily(this.modifications_.get(cfName));
        }
        table.apply(emptyRow);
    }

    void applyBinary(Row emptyRow) throws IOException, ExecutionException, InterruptedException {
        assert (emptyRow.getColumnFamilies().size() == 0);
        Table table = Table.open(this.table_);
        Set<String> cfNames = this.modifications_.keySet();
        for (String cfName : cfNames) {
            assert (table.isValidColumnFamily(cfName));
            emptyRow.addColumnFamily(this.modifications_.get(cfName));
        }
        table.load(emptyRow);
    }

    public Message makeRowMutationMessage() throws IOException {
        return this.makeRowMutationMessage("ROW-MUTATION-VERB-HANDLER");
    }

    public Message makeRowMutationMessage(String verbHandlerName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        RowMutation.serializer().serialize(this, dos);
        EndPoint local = StorageService.getLocalStorageEndPoint();
        EndPoint from = local != null ? local : new EndPoint(FBUtilities.getHostAddress(), 7000);
        return new Message(from, "ROW-MUTATION-STAGE", verbHandlerName, bos.toByteArray());
    }

    public static RowMutation getRowMutation(String table, String key, Map<String, List<ColumnOrSuperColumn>> cfmap) {
        RowMutation rm = new RowMutation(table, key.trim());
        for (Map.Entry<String, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
            String cfName = entry.getKey();
            for (ColumnOrSuperColumn cosc : entry.getValue()) {
                if (cosc.column == null) {
                    assert (cosc.super_column != null);
                    for (Column column : cosc.super_column.columns) {
                        rm.add(new QueryPath(cfName, cosc.super_column.name, column.name), column.value, column.timestamp);
                    }
                    continue;
                }
                assert (cosc.super_column == null);
                rm.add(new QueryPath(cfName, null, cosc.column.name), cosc.column.value, cosc.column.timestamp);
            }
        }
        return rm;
    }

    public String toString() {
        return "RowMutation(table='" + this.table_ + '\'' + ", key='" + this.key_ + '\'' + ", modifications=[" + StringUtils.join(this.modifications_.values(), (String)", ") + "]" + ')';
    }
}

