/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RowSerializer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Row {
    private static Logger logger_ = Logger.getLogger(Row.class);
    private String table_;
    private static RowSerializer serializer = new RowSerializer();
    private String key_;
    private Map<String, ColumnFamily> columnFamilies_ = new HashMap<String, ColumnFamily>();

    static RowSerializer serializer() {
        return serializer;
    }

    public Row(String table, String key) {
        assert (table != null);
        this.table_ = table;
        this.key_ = key;
    }

    Row() {
    }

    public String getTable() {
        return this.table_;
    }

    public String key() {
        return this.key_;
    }

    void setKey(String key) {
        this.key_ = key;
    }

    public void setTable(String table) {
        this.table_ = table;
    }

    public Set<String> getColumnFamilyNames() {
        return this.columnFamilies_.keySet();
    }

    public Collection<ColumnFamily> getColumnFamilies() {
        return this.columnFamilies_.values();
    }

    public ColumnFamily getColumnFamily(String cfName) {
        return this.columnFamilies_.get(cfName);
    }

    void addColumnFamily(ColumnFamily columnFamily) {
        this.columnFamilies_.put(columnFamily.name(), columnFamily);
    }

    void removeColumnFamily(ColumnFamily columnFamily) {
        this.columnFamilies_.remove(columnFamily.name());
    }

    public boolean isEmpty() {
        return this.columnFamilies_.size() == 0;
    }

    public void repair(Row rowOther) {
        for (ColumnFamily cfOld : rowOther.getColumnFamilies()) {
            ColumnFamily cf = this.columnFamilies_.get(cfOld.name());
            if (cf == null) {
                this.addColumnFamily(cfOld);
                continue;
            }
            this.columnFamilies_.remove(cf.name());
            this.addColumnFamily(ColumnFamily.resolve(Arrays.asList(cfOld, cf)));
        }
    }

    public Row diff(Row rowComposite) {
        Row rowDiff = new Row(this.table_, this.key_);
        for (ColumnFamily cfComposite : rowComposite.getColumnFamilies()) {
            ColumnFamily cf = this.columnFamilies_.get(cfComposite.name());
            if (cf == null) {
                rowDiff.addColumnFamily(cfComposite);
                continue;
            }
            ColumnFamily cfDiff = cf.diff(cfComposite);
            if (cfDiff == null) continue;
            rowDiff.addColumnFamily(cfDiff);
        }
        if (rowDiff.getColumnFamilies().isEmpty()) {
            return null;
        }
        return rowDiff;
    }

    public Row cloneMe() {
        Row row = new Row(this.table_, this.key_);
        row.columnFamilies_ = new HashMap<String, ColumnFamily>(this.columnFamilies_);
        return row;
    }

    public byte[] digest() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        for (String cFamily : this.columnFamilies_.keySet()) {
            this.columnFamilies_.get(cFamily).updateDigest(digest);
        }
        return digest.digest();
    }

    void clear() {
        this.columnFamilies_.clear();
    }

    public String toString() {
        return "Row(" + this.key_ + " [" + StringUtils.join(this.columnFamilies_.values(), (String)", ") + ")]";
    }
}

