/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CommitLog;
import org.apache.cassandra.utils.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RecoveryManager {
    private static RecoveryManager instance_;
    private static Logger logger_;

    public static synchronized RecoveryManager instance() throws IOException {
        if (instance_ == null) {
            instance_ = new RecoveryManager();
        }
        return instance_;
    }

    public static File[] getListofCommitLogs() {
        String directory = DatabaseDescriptor.getLogFileLocation();
        File file = new File(directory);
        return file.listFiles();
    }

    public static void doRecovery() throws IOException {
        Object[] files = RecoveryManager.getListofCommitLogs();
        if (files.length == 0) {
            return;
        }
        Arrays.sort(files, new FileUtils.FileComparator());
        logger_.info((Object)("Replaying " + StringUtils.join((Object[])files, (String)", ")));
        new CommitLog(true).recover((File[])files);
        FileUtils.delete((File[])files);
    }

    static {
        logger_ = Logger.getLogger(RecoveryManager.class);
    }
}

