/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.log4j.Logger;

public class ReadVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(ReadVerbHandler.class);
    private static ThreadLocal<ReadContext> tls_ = new InheritableThreadLocal<ReadContext>();

    protected static ReadContext getCurrentReadContext() {
        return tls_.get();
    }

    protected static void setCurrentReadContext(ReadContext readContext) {
        tls_.set(readContext);
    }

    @Override
    public void doVerb(Message message) {
        byte[] body = message.getMessageBody();
        ReadContext readCtx = tls_.get();
        if (readCtx == null) {
            readCtx = new ReadContext();
            tls_.set(readCtx);
        }
        readCtx.bufIn_.reset(body, body.length);
        try {
            if (StorageService.instance().isBootstrapMode()) {
                throw new RuntimeException("Cannot service reads while bootstrapping!");
            }
            ReadCommand readCommand = ReadCommand.serializer().deserialize(readCtx.bufIn_);
            Table table = Table.open(readCommand.table);
            Row row = null;
            row = readCommand.getRow(table);
            ReadResponse readResponse = null;
            readResponse = readCommand.isDigestQuery() ? new ReadResponse(row.digest()) : new ReadResponse(row);
            readResponse.setIsDigestQuery(readCommand.isDigestQuery());
            readCtx.bufOut_.reset();
            ReadResponse.serializer().serialize(readResponse, readCtx.bufOut_);
            byte[] bytes = new byte[readCtx.bufOut_.getLength()];
            System.arraycopy(readCtx.bufOut_.getData(), 0, bytes, 0, bytes.length);
            Message response = message.getReply(StorageService.getLocalStorageEndPoint(), bytes);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Read key " + readCommand.key + "; sending response to " + message.getMessageId() + "@" + message.getFrom()));
            }
            MessagingService.getMessagingInstance().sendOneWay(response, message.getFrom());
            if (message.getHeader("READ-REPAIR") != null) {
                this.doReadRepair(row, readCommand);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void doReadRepair(Row row, ReadCommand readCommand) {
        List<EndPoint> endpoints = StorageService.instance().getLiveReadStorageEndPoints(readCommand.key);
        endpoints.remove(StorageService.getLocalStorageEndPoint());
        if (endpoints.size() > 0 && DatabaseDescriptor.getConsistencyCheck()) {
            StorageService.instance().doConsistencyCheck(row, endpoints, readCommand);
        }
    }

    protected static class ReadContext {
        protected DataInputBuffer bufIn_ = new DataInputBuffer();
        protected DataOutputBuffer bufOut_ = new DataOutputBuffer();

        protected ReadContext() {
        }
    }
}

