/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.ICompactSerializer;

class ReadResponseSerializer
implements ICompactSerializer<ReadResponse> {
    ReadResponseSerializer() {
    }

    @Override
    public void serialize(ReadResponse rm, DataOutputStream dos) throws IOException {
        dos.writeInt(rm.digest().length);
        dos.write(rm.digest());
        dos.writeBoolean(rm.isDigestQuery());
        if (!rm.isDigestQuery() && rm.row() != null) {
            Row.serializer().serialize(rm.row(), dos);
        }
    }

    @Override
    public ReadResponse deserialize(DataInputStream dis) throws IOException {
        int digestSize = dis.readInt();
        byte[] digest = new byte[digestSize];
        dis.read(digest, 0, digestSize);
        boolean isDigest = dis.readBoolean();
        Row row = null;
        if (!isDigest) {
            row = Row.serializer().deserialize(dis);
        }
        ReadResponse rmsg = null;
        rmsg = isDigest ? new ReadResponse(digest) : new ReadResponse(row);
        rmsg.setIsDigestQuery(isDigest);
        return rmsg;
    }
}

