/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.db.ReadResponseSerializer;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.commons.lang.ArrayUtils;

public class ReadResponse {
    private static ICompactSerializer<ReadResponse> serializer_ = new ReadResponseSerializer();
    private Row row_;
    private byte[] digest_ = ArrayUtils.EMPTY_BYTE_ARRAY;
    private boolean isDigestQuery_ = false;

    public static ICompactSerializer<ReadResponse> serializer() {
        return serializer_;
    }

    public static Message makeReadResponseMessage(ReadResponse readResponse) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        ReadResponse.serializer().serialize(readResponse, dos);
        Message message = new Message(StorageService.getLocalStorageEndPoint(), "RESPONSE-STAGE", "RESPONSE", bos.toByteArray());
        return message;
    }

    public ReadResponse(byte[] digest) {
        assert (digest != null);
        this.digest_ = digest;
    }

    public ReadResponse(Row row) {
        this.row_ = row;
    }

    public Row row() {
        return this.row_;
    }

    public byte[] digest() {
        return this.digest_;
    }

    public boolean isDigestQuery() {
        return this.isDigestQuery_;
    }

    public void setIsDigestQuery(boolean isDigestQuery) {
        this.isDigestQuery_ = isDigestQuery;
    }
}

