/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.ThreadFactoryImpl;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.IdentityQueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.InvalidRequestException;
import org.apache.cassandra.service.QuorumResponseHandler;
import org.apache.cassandra.service.WriteResponseResolver;
import org.apache.log4j.Logger;

public class HintedHandOffManager {
    private static HintedHandOffManager instance_;
    private static Lock lock_;
    private static Logger logger_;
    static final long intervalInMins_ = 60L;
    private ScheduledExecutorService executor_ = new DebuggableScheduledThreadPoolExecutor(1, new ThreadFactoryImpl("HINTED-HANDOFF-POOL"));
    public static final String HINTS_CF = "HintsColumnFamily";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HintedHandOffManager instance() {
        if (instance_ == null) {
            lock_.lock();
            try {
                if (instance_ == null) {
                    instance_ = new HintedHandOffManager();
                }
            }
            finally {
                lock_.unlock();
            }
        }
        return instance_;
    }

    private static boolean sendMessage(String endpointAddress, String tableName, String key) throws DigestMismatchException, TimeoutException, IOException, InvalidRequestException {
        EndPoint endPoint = new EndPoint(endpointAddress, DatabaseDescriptor.getStoragePort());
        if (!FailureDetector.instance().isAlive(endPoint)) {
            return false;
        }
        Table table = Table.open(tableName);
        Row row = table.get(key);
        Row purgedRow = new Row(tableName, key);
        for (ColumnFamily cf : row.getColumnFamilies()) {
            purgedRow.addColumnFamily(ColumnFamilyStore.removeDeleted(cf));
        }
        RowMutation rm = new RowMutation(tableName, purgedRow);
        Message message = rm.makeRowMutationMessage();
        QuorumResponseHandler<Boolean> quorumResponseHandler = new QuorumResponseHandler<Boolean>(1, new WriteResponseResolver());
        MessagingService.getMessagingInstance().sendRR(message, new EndPoint[]{endPoint}, quorumResponseHandler);
        return quorumResponseHandler.get();
    }

    private static void deleteEndPoint(byte[] endpointAddress, String tableName, byte[] key, long timestamp) throws IOException {
        RowMutation rm = new RowMutation("system", tableName);
        rm.delete(new QueryPath(HINTS_CF, key, endpointAddress), timestamp);
        rm.apply();
    }

    private static void deleteHintedData(String tableName, String key) throws IOException {
        RowMutation rm = new RowMutation(tableName, key);
        Table table = Table.open(tableName);
        Row row = table.get(key);
        Collection<ColumnFamily> cfs = row.getColumnFamilies();
        for (ColumnFamily cf : cfs) {
            long maxTS = Long.MIN_VALUE;
            if (!cf.isSuper()) {
                for (IColumn col : cf.getSortedColumns()) {
                    maxTS = Math.max(maxTS, col.timestamp());
                }
            } else {
                for (IColumn col : cf.getSortedColumns()) {
                    maxTS = Math.max(maxTS, col.timestamp());
                    Collection<IColumn> subColumns = col.getSubColumns();
                    for (IColumn subCol : subColumns) {
                        maxTS = Math.max(maxTS, subCol.timestamp());
                    }
                }
            }
            rm.delete(new QueryPath(cf.name()), maxTS);
        }
        rm.apply();
    }

    private static void deliverAllHints(ColumnFamilyStore hintStore) throws DigestMismatchException, IOException, InvalidRequestException, TimeoutException {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"Started deliverAllHints");
        }
        for (String tableName : DatabaseDescriptor.getTables()) {
            ColumnFamily hintColumnFamily = ColumnFamilyStore.removeDeleted(hintStore.getColumnFamily(new IdentityQueryFilter(tableName, new QueryPath(HINTS_CF))), Integer.MAX_VALUE);
            if (hintColumnFamily == null) continue;
            Collection<IColumn> keys = hintColumnFamily.getSortedColumns();
            for (IColumn keyColumn : keys) {
                Collection<IColumn> endpoints = keyColumn.getSubColumns();
                String keyStr = new String(keyColumn.name(), "UTF-8");
                int deleted = 0;
                for (IColumn endpoint : endpoints) {
                    String endpointStr = new String(endpoint.name(), "UTF-8");
                    if (!HintedHandOffManager.sendMessage(endpointStr, tableName, keyStr)) continue;
                    HintedHandOffManager.deleteEndPoint(endpoint.name(), tableName, keyColumn.name(), keyColumn.timestamp());
                    ++deleted;
                }
                if (deleted != endpoints.size()) continue;
                HintedHandOffManager.deleteHintedData(tableName, keyStr);
            }
        }
        hintStore.forceFlush();
        hintStore.forceCompaction(null, null, 0L, null);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"Finished deliverAllHints");
        }
    }

    private static void deliverHintsToEndpoint(EndPoint endPoint) throws IOException, DigestMismatchException, InvalidRequestException, TimeoutException {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Started hinted handoff for endPoint " + endPoint.getHost()));
        }
        String targetEPBytes = endPoint.getHost();
        Table systemTable = Table.open("system");
        for (String tableName : DatabaseDescriptor.getTables()) {
            ColumnFamily hintedColumnFamily = systemTable.get(tableName, HINTS_CF);
            if (hintedColumnFamily == null) continue;
            Collection<IColumn> keys = hintedColumnFamily.getSortedColumns();
            for (IColumn keyColumn : keys) {
                String keyStr = new String(keyColumn.name(), "UTF-8");
                Collection<IColumn> endpoints = keyColumn.getSubColumns();
                for (IColumn hintEndPoint : endpoints) {
                    if (!hintEndPoint.name().equals(targetEPBytes) || !HintedHandOffManager.sendMessage(endPoint.getHost(), null, keyStr)) continue;
                    HintedHandOffManager.deleteEndPoint(hintEndPoint.name(), tableName, keyColumn.name(), keyColumn.timestamp());
                    if (endpoints.size() != 1) continue;
                    HintedHandOffManager.deleteHintedData(tableName, keyStr);
                }
            }
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Finished hinted handoff for endpoint " + endPoint.getHost()));
        }
    }

    public void submit(final ColumnFamilyStore columnFamilyStore) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    HintedHandOffManager.deliverAllHints(columnFamilyStore);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor_.scheduleWithFixedDelay(r, 60L, 60L, TimeUnit.MINUTES);
    }

    public void deliverHints(final EndPoint to) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    HintedHandOffManager.deliverHintsToEndpoint(to);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor_.submit(r);
    }

    static {
        lock_ = new ReentrantLock();
        logger_ = Logger.getLogger(HintedHandOffManager.class);
    }
}

