/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SuperColumnSerializer;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.log4j.Logger;

public final class ColumnFamily
implements IColumnContainer {
    private static ColumnFamilySerializer serializer_ = new ColumnFamilySerializer();
    public static final short utfPrefix_ = 2;
    private static Logger logger_ = Logger.getLogger(ColumnFamily.class);
    private static Map<String, String> columnTypes_ = new HashMap<String, String>();
    String type_;
    private String table_;
    private String name_;
    private transient ICompactSerializer2<IColumn> columnSerializer_;
    long markedForDeleteAt = Long.MIN_VALUE;
    int localDeletionTime = Integer.MIN_VALUE;
    private AtomicInteger size_ = new AtomicInteger(0);
    private ConcurrentSkipListMap<byte[], IColumn> columns_;

    public static ColumnFamilySerializer serializer() {
        return serializer_;
    }

    public static String getColumnType(String key) {
        if (key == null) {
            return columnTypes_.get("Standard");
        }
        return columnTypes_.get(key);
    }

    public static ColumnFamily create(String tableName, String cfName) {
        String columnType = DatabaseDescriptor.getColumnFamilyType(tableName, cfName);
        AbstractType comparator = DatabaseDescriptor.getComparator(tableName, cfName);
        AbstractType subcolumnComparator = DatabaseDescriptor.getSubComparator(tableName, cfName);
        return new ColumnFamily(cfName, columnType, comparator, subcolumnComparator);
    }

    public ColumnFamily(String cfName, String columnType, AbstractType comparator, AbstractType subcolumnComparator) {
        this.name_ = cfName;
        this.type_ = columnType;
        this.columnSerializer_ = columnType.equals("Standard") ? Column.serializer() : SuperColumn.serializer(subcolumnComparator);
        this.columns_ = new ConcurrentSkipListMap(comparator);
    }

    public ColumnFamily cloneMeShallow() {
        ColumnFamily cf = new ColumnFamily(this.name_, this.type_, this.getComparator(), this.getSubComparator());
        cf.markedForDeleteAt = this.markedForDeleteAt;
        cf.localDeletionTime = this.localDeletionTime;
        return cf;
    }

    private AbstractType getSubComparator() {
        return this.columnSerializer_ instanceof SuperColumnSerializer ? ((SuperColumnSerializer)this.columnSerializer_).getComparator() : null;
    }

    ColumnFamily cloneMe() {
        ColumnFamily cf = this.cloneMeShallow();
        cf.columns_ = this.columns_.clone();
        return cf;
    }

    public String name() {
        return this.name_;
    }

    void addColumns(ColumnFamily cf) {
        for (IColumn column : cf.getSortedColumns()) {
            this.addColumn(column);
        }
    }

    public ICompactSerializer2<IColumn> getColumnSerializer() {
        return this.columnSerializer_;
    }

    int getColumnCount() {
        int count = 0;
        if (!this.isSuper()) {
            count = this.columns_.size();
        } else {
            for (IColumn column : this.columns_.values()) {
                count += column.getObjectCount();
            }
        }
        return count;
    }

    public boolean isSuper() {
        return this.type_.equals("Super");
    }

    public void addColumn(QueryPath path, byte[] value, long timestamp) {
        this.addColumn(path, value, timestamp, false);
    }

    public void addColumn(QueryPath path, byte[] value, long timestamp, boolean deleted) {
        IColumn column;
        assert (path.columnName != null) : path;
        if (path.superColumnName == null) {
            column = new Column(path.columnName, value, timestamp, deleted);
        } else {
            assert (this.isSuper());
            column = new SuperColumn(path.superColumnName, this.getSubComparator());
            column.addColumn(new Column(path.columnName, value, timestamp, deleted));
        }
        this.addColumn(column);
    }

    public void clear() {
        this.columns_.clear();
        this.size_.set(0);
    }

    @Override
    public void addColumn(IColumn column) {
        byte[] name = column.name();
        IColumn oldColumn = this.columns_.get(name);
        if (oldColumn != null) {
            if (oldColumn instanceof SuperColumn) {
                int oldSize = oldColumn.size();
                ((SuperColumn)oldColumn).putColumn(column);
                this.size_.addAndGet(oldColumn.size() - oldSize);
            } else if (((Column)oldColumn).comparePriority((Column)column) <= 0L) {
                this.columns_.put(name, column);
                this.size_.addAndGet(column.size());
            }
        } else {
            this.size_.addAndGet(column.size());
            this.columns_.put(name, column);
        }
    }

    public IColumn getColumn(byte[] name) {
        return this.columns_.get(name);
    }

    public SortedSet<byte[]> getColumnNames() {
        return this.columns_.keySet();
    }

    public Collection<IColumn> getSortedColumns() {
        return this.columns_.values();
    }

    public Map<byte[], IColumn> getColumnsMap() {
        return this.columns_;
    }

    public void remove(byte[] columnName) {
        this.columns_.remove(columnName);
    }

    public void delete(int localtime, long timestamp) {
        this.localDeletionTime = localtime;
        this.markedForDeleteAt = timestamp;
    }

    public void delete(ColumnFamily cf2) {
        this.delete(Math.max(this.getLocalDeletionTime(), cf2.getLocalDeletionTime()), Math.max(this.getMarkedForDeleteAt(), cf2.getMarkedForDeleteAt()));
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.markedForDeleteAt > Long.MIN_VALUE;
    }

    ColumnFamily diff(ColumnFamily cfComposite) {
        ColumnFamily cfDiff = new ColumnFamily(cfComposite.name(), cfComposite.type_, this.getComparator(), this.getSubComparator());
        if (cfComposite.getMarkedForDeleteAt() > this.getMarkedForDeleteAt()) {
            cfDiff.delete(cfComposite.getLocalDeletionTime(), cfComposite.getMarkedForDeleteAt());
        }
        Map<byte[], IColumn> columns = cfComposite.getColumnsMap();
        Set<byte[]> cNames = columns.keySet();
        for (byte[] cName : cNames) {
            IColumn columnInternal = this.columns_.get(cName);
            IColumn columnExternal = columns.get(cName);
            if (columnInternal == null) {
                cfDiff.addColumn(columnExternal);
                continue;
            }
            IColumn columnDiff = columnInternal.diff(columnExternal);
            if (columnDiff == null) continue;
            cfDiff.addColumn(columnDiff);
        }
        if (!cfDiff.getColumnsMap().isEmpty() || cfDiff.isMarkedForDelete()) {
            return cfDiff;
        }
        return null;
    }

    @Override
    public AbstractType getComparator() {
        return (AbstractType)this.columns_.comparator();
    }

    int size() {
        if (this.size_.get() == 0) {
            for (IColumn column : this.columns_.values()) {
                this.size_.addAndGet(column.size());
            }
        }
        return this.size_.get();
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColumnFamily)) {
            return false;
        }
        ColumnFamily cf = (ColumnFamily)o;
        return this.name().equals(cf.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ColumnFamily(");
        sb.append(this.name_);
        if (this.isMarkedForDelete()) {
            sb.append(" -delete at " + this.getMarkedForDeleteAt() + "-");
        }
        sb.append(" [");
        sb.append(this.getComparator().getColumnsString(this.getSortedColumns()));
        sb.append("])");
        return sb.toString();
    }

    public void updateDigest(MessageDigest digest) {
        for (IColumn column : this.columns_.values()) {
            column.updateDigest(digest);
        }
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.markedForDeleteAt;
    }

    public int getLocalDeletionTime() {
        return this.localDeletionTime;
    }

    public String type() {
        return this.type_;
    }

    String getComparatorName() {
        return this.getComparator().getClass().getCanonicalName();
    }

    String getSubComparatorName() {
        AbstractType subcolumnComparator = this.getSubComparator();
        return subcolumnComparator == null ? "" : subcolumnComparator.getClass().getCanonicalName();
    }

    public int serializedSize() {
        int subtotal = 8 + this.name_.length() + this.type_.length() + this.getComparatorName().length() + this.getSubComparatorName().length() + 4 + 8 + 4;
        for (IColumn column : this.columns_.values()) {
            subtotal += column.serializedSize();
        }
        return subtotal;
    }

    static ColumnFamily resolve(List<ColumnFamily> columnFamilies) {
        int size = columnFamilies.size();
        if (size == 0) {
            return null;
        }
        ColumnFamily cf0 = columnFamilies.get(0);
        ColumnFamily cf = cf0.cloneMeShallow();
        for (ColumnFamily cf2 : columnFamilies) {
            assert (cf.name().equals(cf2.name()));
            cf.addColumns(cf2);
            cf.delete(cf2);
        }
        return cf;
    }

    public static AbstractType getComparatorFor(String table, String columnFamilyName, byte[] superColumnName) {
        return superColumnName == null ? DatabaseDescriptor.getComparator(table, columnFamilyName) : DatabaseDescriptor.getSubComparator(table, columnFamilyName);
    }

    static {
        columnTypes_.put("Standard", "Standard");
        columnTypes_.put("Super", "Super");
    }
}

