/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.cassandra.concurrent.IStage;

public class StageManager {
    private static Map<String, IStage> stageQueues_ = new HashMap<String, IStage>();

    public static void registerStage(String stageName, IStage stage) {
        stageQueues_.put(stageName, stage);
    }

    public static IStage getCurrentStage() {
        String name = Thread.currentThread().getName();
        String[] peices = name.split(":");
        IStage stage = StageManager.getStage(peices[0]);
        return stage;
    }

    public static IStage getStage(String stageName) {
        return stageQueues_.get(stageName);
    }

    public static ExecutorService getStageInternalThreadPool(String stageName) {
        IStage stage = StageManager.getStage(stageName);
        if (stage == null) {
            throw new IllegalArgumentException("No stage registered with name " + stageName);
        }
        return stage.getInternalThreadPool();
    }

    public static void deregisterStage(String stageName) {
        stageQueues_.remove(stageName);
    }

    public static long getStageTaskCount(String stage) {
        return stageQueues_.get(stage).getPendingTasks();
    }

    public static void shutdown() {
        Set<String> stages = stageQueues_.keySet();
        for (String stage : stages) {
            IStage registeredStage = stageQueues_.get(stage);
            registeredStage.shutdown();
        }
    }
}

