/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.client;

import flexjson.JSONTokener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.Cassandra;
import org.apache.cassandra.service.CassandraServer;
import org.apache.cassandra.service.StorageService;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class RingCache {
    private static final Logger logger_ = Logger.getLogger(RingCache.class);
    private Set<String> seeds_ = new HashSet<String>();
    private final int port_ = DatabaseDescriptor.getThriftPort();
    private volatile AbstractReplicationStrategy nodePicker_;
    private static final IPartitioner partitioner_ = DatabaseDescriptor.getPartitioner();

    public RingCache() {
        this.seeds_ = DatabaseDescriptor.getSeeds();
        this.refreshEndPointMap();
    }

    public void refreshEndPointMap() {
        for (String seed : this.seeds_) {
            try {
                TSocket socket = new TSocket(seed, this.port_);
                TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)socket, false, false);
                Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
                socket.open();
                Map tokenToHostMap = (Map)new JSONTokener(client.get_string_property(CassandraServer.TOKEN_MAP)).nextValue();
                HashMap<Token, EndPoint> tokenEndpointMap = new HashMap<Token, EndPoint>();
                HashMap<EndPoint, Token> endpointTokenMap = new HashMap<EndPoint, Token>();
                for (Map.Entry entry : tokenToHostMap.entrySet()) {
                    Token token = StorageService.getPartitioner().getTokenFactory().fromString((String)entry.getKey());
                    String host = (String)entry.getValue();
                    tokenEndpointMap.put(token, new EndPoint(host, this.port_));
                    endpointTokenMap.put(new EndPoint(host, this.port_), token);
                }
                TokenMetadata tokenMetadata = new TokenMetadata(tokenEndpointMap, endpointTokenMap, null);
                Class cls = DatabaseDescriptor.getReplicaPlacementStrategyClass();
                Class[] parameterTypes = new Class[]{TokenMetadata.class, IPartitioner.class, Integer.TYPE, Integer.TYPE};
                try {
                    this.nodePicker_ = (AbstractReplicationStrategy)cls.getConstructor(parameterTypes).newInstance(tokenMetadata, partitioner_, DatabaseDescriptor.getReplicationFactor(), this.port_);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (TException e) {
                logger_.debug((Object)("Error contacting seed " + seed + " " + e.getMessage()));
            }
        }
    }

    public EndPoint[] getEndPoint(String key) {
        return this.nodePicker_.getReadStorageEndPoints((Token)partitioner_.getToken(key));
    }
}

