/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

public class CliUtils {
    public static String unescapeSQLString(String b) {
        assert (b.charAt(0) == '\'');
        assert (b.charAt(b.length() - 1) == '\'');
        StringBuilder sb = new StringBuilder(b.length());
        int i = 1;
        while (i + 1 < b.length()) {
            if (b.charAt(i) == '\\' && i + 2 < b.length()) {
                char n = b.charAt(i + 1);
                switch (n) {
                    case '0': {
                        sb.append("\u0000");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'Z': {
                        sb.append("\u001a");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    case '%': {
                        sb.append("%");
                        break;
                    }
                    case '_': {
                        sb.append("_");
                        break;
                    }
                    default: {
                        sb.append(n);
                        break;
                    }
                }
            } else {
                sb.append(b.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

