/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import org.apache.cassandra.cli.CliSessionState;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CliOptions {
    private static Options options = null;
    private CommandLine cmd = null;
    private static final String HOST_OPTION = "host";
    private static final String PORT_OPTION = "port";
    private static final int DEFAULT_THRIFT_PORT = 9160;

    private static void printUsage() {
        System.err.println("");
        System.err.println("Usage: cassandra-cli --host hostname [--port <portname>]");
        System.err.println("");
    }

    public void processArgs(CliSessionState css, String[] args) {
        PosixParser parser = new PosixParser();
        try {
            this.cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            CliOptions.printUsage();
            e.printStackTrace();
            System.exit(1);
        }
        css.hostName = !this.cmd.hasOption(HOST_OPTION) ? null : this.cmd.getOptionValue(HOST_OPTION);
        css.thriftPort = this.cmd.hasOption(PORT_OPTION) ? Integer.parseInt(this.cmd.getOptionValue(PORT_OPTION)) : 9160;
    }

    static {
        options = new Options();
        options.addOption(HOST_OPTION, true, "cassandra server's host name");
        options.addOption(PORT_OPTION, true, "cassandra server's thrift port");
    }
}

