/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples.sdk;

import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.Field;
import org.apache.carbondata.sdk.file.CarbonSchemaReader;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class SDKS3SchemaReadExample {
    public static void main(String[] args) throws Exception {
        Logger logger = LogServiceFactory.getLogService((String)SDKS3SchemaReadExample.class.getName());
        if (args == null || args.length < 3) {
            logger.error((Object)"Usage: java CarbonS3Example: <access-key> <secret-key><s3-endpoint> [table-path-on-s3]");
            System.exit(0);
        }
        String path = "s3a://sdk/WriterOutput/carbondata2/";
        if (args.length > 3) {
            path = args[3];
        }
        Configuration configuration = new Configuration();
        configuration.set("fs.s3a.access.key", args[0]);
        configuration.set("fs.s3a.secret.key", args[1]);
        configuration.set("fs.s3a.endpoint", args[2]);
        Schema schema = CarbonSchemaReader.readSchema((String)path, (boolean)true, (Configuration)configuration);
        System.out.println("Schema length is " + schema.getFieldsLength());
        Field[] fields = schema.getFields();
        for (int i = 0; i < fields.length; ++i) {
            System.out.println(fields[i] + "\t");
        }
        Schema schema2 = CarbonSchemaReader.readSchema((String)path, (Configuration)configuration);
        System.out.println("Schema length is " + schema2.getFieldsLength());
        Field[] fields2 = schema2.getFields();
        for (int i = 0; i < fields2.length; ++i) {
            System.out.println(fields2[i] + "\t");
        }
    }
}

