/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples.util;

import java.io.File;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ExampleUtils$ {
    public static final ExampleUtils$ MODULE$;
    private final String storeLocation;

    static {
        new ExampleUtils$();
    }

    public String currentPath() {
        return new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../").toString()).getCanonicalPath();
    }

    public String storeLocation() {
        return this.storeLocation;
    }

    public SparkSession createCarbonSession(String appName, int workThreadNum, String storePath) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String warehouse = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target/warehouse"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        String metaStoreDB = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        String storeLocation = storePath == null ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target/store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})) : storePath;
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy/MM/dd HH:mm:ss").addProperty("carbon.date.format", "yyyy/MM/dd").addProperty("enable.unsafe.columnpage", "true").addProperty("carbon.badRecords.location", "");
        String masterUrl = workThreadNum <= 1 ? "local" : new StringBuilder().append((Object)"local[").append((Object)((Object)BoxesRunTime.boxToInteger((int)workThreadNum)).toString()).append((Object)"]").toString();
        SparkSession spark = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master(masterUrl).appName(appName).config("spark.sql.warehouse.dir", warehouse).config("spark.driver.host", "localhost").config("spark.sql.crossJoin.enabled", "true")).getOrCreateCarbonSession(storeLocation, metaStoreDB);
        spark.sparkContext().setLogLevel("ERROR");
        return spark;
    }

    public int createCarbonSession$default$2() {
        return 1;
    }

    public String createCarbonSession$default$3() {
        return null;
    }

    public String writeSampleCarbonFile(SparkSession spark, String tableName, int numRows) {
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        this.writeDataframe(spark, tableName, numRows, SaveMode.Overwrite);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/default/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeLocation(), tableName}));
    }

    public int writeSampleCarbonFile$default$3() {
        return 1000;
    }

    public String appendSampleCarbonFile(SparkSession spark, String tableName, int numRows) {
        this.writeDataframe(spark, tableName, numRows, SaveMode.Append);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/default/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeLocation(), tableName}));
    }

    public int appendSampleCarbonFile$default$3() {
        return 1000;
    }

    private void writeDataframe(SparkSession spark, String tableName, int numRows, SaveMode mode) {
        SparkContext sc = spark.sparkContext();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_util_ExampleUtils$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
            }

            public Org_apache_carbondata_examples_util_ExampleUtils$$typecreator5$1() {
            }
        }
        Dataset df = spark.implicits().rddToDatasetHolder(sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRows), 2, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, String, Object> apply(int x) {
                return new Tuple3((Object)"a", (Object)"b", (Object)BoxesRunTime.boxToInteger((int)x));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_util_ExampleUtils$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
        df.write().format("carbondata").option("tableName", tableName).option("compress", "true").option("tempCSV", "false").mode(mode).save();
    }

    public void cleanSampleCarbonFile(SparkSession spark, String tableName) {
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
    }

    private ExampleUtils$() {
        MODULE$ = this;
        this.storeLocation = new StringBuilder().append((Object)this.currentPath()).append((Object)"/target/store").toString();
    }
}

