/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples.util;

import java.io.DataOutputStream;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.examples.util.AllDictionaryUtil$;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class AllDictionaryUtil$ {
    public static final AllDictionaryUtil$ MODULE$;
    private final Logger org$apache$carbondata$examples$util$AllDictionaryUtil$$LOGGER;

    static {
        new AllDictionaryUtil$();
    }

    public Logger org$apache$carbondata$examples$util$AllDictionaryUtil$$LOGGER() {
        return this.org$apache$carbondata$examples$util$AllDictionaryUtil$$LOGGER;
    }

    public void extractDictionary(SparkContext sc, String srcData, String outputPath, String fileHeader, String dictCol) {
        String[] fileHeaderArr = fileHeader.split(",");
        boolean[] isDictCol = new boolean[fileHeaderArr.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fileHeaderArr.length).foreach$mVc$sp((Function1)new Serializable(dictCol, fileHeaderArr, isDictCol){
            public static final long serialVersionUID = 0L;
            private final String dictCol$1;
            private final String[] fileHeaderArr$1;
            private final boolean[] isDictCol$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.isDictCol$1[i] = this.dictCol$1.contains(new StringBuilder().append((Object)"|").append((Object)this.fileHeaderArr$1[i].toLowerCase()).append((Object)"|").toString());
            }
            {
                this.dictCol$1 = dictCol$1;
                this.fileHeaderArr$1 = fileHeaderArr$1;
                this.isDictCol$1 = isDictCol$1;
            }
        });
        RDD dictionaryRdd = RDD$.MODULE$.rddToPairRDDFunctions(sc.textFile(srcData, sc.textFile$default$2()).flatMap((Function1)new Serializable(isDictCol){
            public static final long serialVersionUID = 0L;
            public final boolean[] isDictCol$1;

            /*
             * WARNING - void declaration
             */
            public final ArrayBuffer<Tuple2<Object, String>> apply(String x) {
                void var3_3;
                String[] tokens = x.split(",");
                ArrayBuffer result = new ArrayBuffer();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.isDictCol$1.length).foreach((Function1)new Serializable(this, tokens, result, x){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final String[] tokens$1;
                    private final ArrayBuffer result$1;
                    private final String x$1;

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final Object apply(int i) {
                        BoxedUnit boxedUnit;
                        if (!this.$outer.isDictCol$1[i]) {
                            boxedUnit = BoxedUnit.UNIT;
                            return boxedUnit;
                        }
                        try {
                            boxedUnit = this.result$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)this.tokens$1[i]));
                            return boxedUnit;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            AllDictionaryUtil$.MODULE$.org$apache$carbondata$examples$util$AllDictionaryUtil$$LOGGER().error((Object)new StringBuilder().append((Object)"Read a bad record: ").append((Object)this.x$1).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tokens$1 = tokens$1;
                        this.result$1 = result$1;
                        this.x$1 = x$1;
                    }
                });
                return var3_3;
            }
            {
                this.isDictCol$1 = isDictCol$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final HashSet<Tuple2<Object, String>> apply(Tuple2<Object, Iterable<String>> x) {
                void var2_2;
                HashSet distinctValues = new HashSet();
                ((IterableLike)x._2()).foreach((Function1)new Serializable(this, distinctValues, x){
                    public static final long serialVersionUID = 0L;
                    private final HashSet distinctValues$1;
                    private final Tuple2 x$2;

                    public final boolean apply(String value) {
                        return this.distinctValues$1.add((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.x$2._1$mcI$sp()), (Object)value));
                    }
                    {
                        this.distinctValues$1 = distinctValues$1;
                        this.x$2 = x$2;
                    }
                });
                return var2_2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        String[] dictionaryValues = (String[])dictionaryRdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, String> x) {
                return new StringBuilder().append(x._1$mcI$sp()).append((Object)",").append(x._2()).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect();
        this.saveToFile(dictionaryValues, outputPath);
    }

    public void cleanDictionary(String outputPath) {
        try {
            FileFactory.FileType fileType = FileFactory.getFileType((String)outputPath);
            CarbonFile file = FileFactory.getCarbonFile((String)outputPath, (FileFactory.FileType)fileType);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            this.org$apache$carbondata$examples$util$AllDictionaryUtil$$LOGGER().error((Object)new StringBuilder().append((Object)"Clean dictionary catching exception:").append((Object)exception).toString());
        }
    }

    public void saveToFile(String[] contents, String outputPath) {
        ObjectRef writer = ObjectRef.create(null);
        try {
            try {
                FileFactory.FileType fileType = FileFactory.getFileType((String)outputPath);
                CarbonFile file = FileFactory.getCarbonFile((String)outputPath, (FileFactory.FileType)fileType);
                Object object = file.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)file.createNewFile());
                writer.elem = FileFactory.getDataOutputStream((String)outputPath, (FileFactory.FileType)fileType);
                Predef$.MODULE$.refArrayOps((Object[])contents).foreach((Function1)new Serializable(writer){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef writer$1;

                    public final void apply(String content) {
                        ((DataOutputStream)this.writer$1.elem).writeBytes(new StringBuilder().append((Object)content).append((Object)"\n").toString());
                    }
                    {
                        this.writer$1 = writer$1;
                    }
                });
            }
            catch (Exception exception) {
                this.org$apache$carbondata$examples$util$AllDictionaryUtil$$LOGGER().error((Object)new StringBuilder().append((Object)"Save dictionary to file catching exception:").append((Object)exception).toString());
            }
        }
        finally {
            if ((DataOutputStream)writer.elem != null) {
                try {
                    ((DataOutputStream)writer.elem).close();
                }
                catch (Exception exception) {
                    this.org$apache$carbondata$examples$util$AllDictionaryUtil$$LOGGER().error((Object)new StringBuilder().append((Object)"Close output stream catching exception:").append((Object)exception).toString());
                }
            }
        }
    }

    private AllDictionaryUtil$() {
        MODULE$ = this;
        this.org$apache$carbondata$examples$util$AllDictionaryUtil$$LOGGER = LogServiceFactory.getLogService((String)this.getClass().getCanonicalName());
    }
}

