/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples.sdk;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.carbondata.sdk.file.CarbonSchemaReader;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.Field;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.commons.io.FileUtils;

public class CarbonReaderExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String path = "./testWriteFiles";
        try {
            FileUtils.deleteDirectory((File)new File(path));
            CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss").addProperty("carbon.date.format", "yyyy-MM-dd");
            Field[] fields = new Field[]{new Field("stringField", DataTypes.STRING), new Field("shortField", DataTypes.SHORT), new Field("intField", DataTypes.INT), new Field("longField", DataTypes.LONG), new Field("doubleField", DataTypes.DOUBLE), new Field("boolField", DataTypes.BOOLEAN), new Field("dateField", DataTypes.DATE), new Field("timeField", DataTypes.TIMESTAMP), new Field("decimalField", (DataType)DataTypes.createDecimalType((int)8, (int)2)), new Field("varcharField", DataTypes.VARCHAR), new Field("arrayField", (DataType)DataTypes.createArrayType((DataType)DataTypes.STRING))};
            CarbonWriter writer = CarbonWriter.builder().outputPath(path).withLoadOption("complex_delimiter_level_1", "#").withCsvInput(new Schema(fields)).writtenBy("CarbonReaderExample").build();
            for (int i = 0; i < 10; ++i) {
                String[] row2 = new String[]{"robot" + i % 10, String.valueOf(i % 10000), String.valueOf(i), String.valueOf(Long.MAX_VALUE - (long)i), String.valueOf((double)i / 2.0), String.valueOf(true), "2019-03-02", "2019-02-12 03:03:34", "12.345", "varchar", "Hello#World#From#Carbon"};
                writer.write((Object)row2);
            }
            writer.close();
            File[] dataFiles = new File(path).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name == null) {
                        return false;
                    }
                    return name.endsWith("carbonindex");
                }
            });
            if (dataFiles == null || dataFiles.length < 1) {
                throw new RuntimeException("Carbon index file not exists.");
            }
            Schema schema = CarbonSchemaReader.readSchema((String)dataFiles[0].getAbsolutePath()).asOriginOrder();
            String[] strings = new String[schema.getFields().length];
            for (int i = 0; i < schema.getFields().length; ++i) {
                strings[i] = schema.getFields()[i].getFieldName();
            }
            CarbonReader reader = CarbonReader.builder((String)path, (String)"_temp").projection(strings).build();
            System.out.println("\nData:");
            long day = 86400000L;
            int i = 0;
            while (reader.hasNext()) {
                Object[] row = (Object[])reader.readNextRow();
                System.out.println(String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t", i, row[0], row[1], row[2], row[3], row[4], row[5], new Date(day * (long)((Integer)row[6]).intValue()), new Timestamp((Long)row[7] / 1000L), row[8], row[9]));
                Object[] arr = (Object[])row[10];
                for (int j = 0; j < arr.length; ++j) {
                    System.out.print(arr[j] + " ");
                }
                assert (arr[0].equals("Hello"));
                assert (arr[3].equals("Carbon"));
                System.out.println();
                ++i;
            }
            reader.close();
            CarbonReader reader2 = CarbonReader.builder((String)path, (String)"_temp").build();
            System.out.println("\nData:");
            i = 0;
            while (reader2.hasNext()) {
                Object[] row = (Object[])reader2.readNextRow();
                System.out.print(String.format("%s\t%s\t%s\t%s\t%s\t", i, row[0], new Date(day * (long)((Integer)row[1]).intValue()), new Timestamp((Long)row[2] / 1000L), row[3]));
                Object[] arr = (Object[])row[4];
                for (int j = 0; j < arr.length; ++j) {
                    System.out.print(arr[j] + " ");
                }
                System.out.println(String.format("\t%s\t%s\t%s\t%s\t%s\t%s\t", row[5], row[6], row[7], row[8], row[9], row[10]));
                ++i;
            }
            reader2.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            assert (false);
            System.out.println(e.getMessage());
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)new File(path));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

