/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.TimeSeriesPreAggregateTableExample$;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class TimeSeriesPreAggregateTableExample$ {
    public static final TimeSeriesPreAggregateTableExample$ MODULE$;

    static {
        new TimeSeriesPreAggregateTableExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("TimeSeriesPreAggregateTableExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String testData = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/spark-common-test/src/test/resources/timeseriestest.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        Random r = new Random();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_TimeSeriesPreAggregateTableExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
            }

            public Org_apache_carbondata_examples_TimeSeriesPreAggregateTableExample$$typecreator5$1() {
            }
        }
        Dataset df = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10000), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final Tuple3<String, String, Object> apply(int x) {
                return new Tuple3((Object)new StringBuilder().append((Object)"").append((Object)BoxesRunTime.boxToInteger((int)20)).append((Object)new StringOps(Predef$.MODULE$.augmentString("%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.r$1.nextInt(20))}))).append((Object)"-").append((Object)new StringOps(Predef$.MODULE$.augmentString("%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.r$1.nextInt(11) + 1))}))).append((Object)"-").append((Object)new StringOps(Predef$.MODULE$.augmentString("%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.r$1.nextInt(27) + 1))}))).append((Object)" ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.r$1.nextInt(12))}))).append((Object)":").append((Object)new StringOps(Predef$.MODULE$.augmentString("%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.r$1.nextInt(59))}))).append((Object)":").append((Object)new StringOps(Predef$.MODULE$.augmentString("%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.r$1.nextInt(59))}))).toString(), (Object)new StringBuilder().append((Object)"name").append((Object)BoxesRunTime.boxToInteger((int)(x % 8))).toString(), (Object)BoxesRunTime.boxToInteger((int)this.r$1.nextInt(60)));
            }
            {
                this.r$1 = r$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_TimeSeriesPreAggregateTableExample$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytime", "name", "age"}));
        spark.sql("drop table if exists timeSeriesTable");
        spark.sql("CREATE TABLE timeSeriesTable(mytime timestamp, name string, age int) STORED BY 'org.apache.carbondata.format'");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE DATAMAP agg0_hour ON TABLE timeSeriesTable\n         | USING 'timeSeries'\n         | DMPROPERTIES (\n         | 'EVENT_TIME'='mytime',\n         | 'HOUR_GRANULARITY'='1')\n         | AS SELECT mytime, SUM(age) FROM timeSeriesTable\n         | GROUP BY mytime\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE DATAMAP agg0_day ON TABLE timeSeriesTable\n         | USING 'timeSeries'\n         | DMPROPERTIES (\n         | 'EVENT_TIME'='mytime',\n         | 'DAY_GRANULARITY'='1')\n         | AS SELECT mytime, SUM(age) FROM timeSeriesTable\n         | GROUP BY mytime\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        df.write().format("carbondata").option("tableName", "timeSeriesTable").option("compress", "true").mode(SaveMode.Append).save();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         select sum(age), timeseries(mytime,'hour') from timeSeriesTable group by timeseries(mytime,\n         'hour')\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         select avg(age),timeseries(mytime,'year') from timeSeriesTable group by timeseries(mytime,\n         'year')\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy-MM-dd");
        spark.sql("DROP TABLE IF EXISTS timeSeriesTable");
    }

    private TimeSeriesPreAggregateTableExample$() {
        MODULE$ = this;
    }
}

