/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.util.Random;
import org.apache.carbondata.examples.MVDataMapExample$;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MVDataMapExample$ {
    public static final MVDataMapExample$ MODULE$;

    static {
        new MVDataMapExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("MVDataMapExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        this.exampleBody(spark);
        this.performanceTest(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String testData = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/spark-common-test/src/test/resources/sample.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        spark.sql("DROP TABLE IF EXISTS mainTable");
        spark.sql("DROP TABLE IF EXISTS dimtable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE mainTable\n        | (id Int,\n        | name String,\n        | city String,\n        | age Int)\n        | STORED BY 'org.apache.carbondata.format'\n      ")).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE dimtable\n        | (name String,\n        | address String)\n        | STORED BY 'org.apache.carbondata.format'\n      ")).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA LOCAL INPATH '", "' into table mainTable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData})));
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into dimtable select name, concat(city, ' street1') as address from\n           |mainTable group by name, address"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap simple_sub_projection using 'mv' as\n         | select id,name from mainTable"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rebuild datamap simple_sub_projection"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id from mainTable"})).s((Seq)Nil$.MODULE$)).explain(true);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select sum(id) from mainTable"})).s((Seq)Nil$.MODULE$)).explain(true);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap simple_agg using 'mv' as\n         | select id,sum(age) from mainTable group by id"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rebuild datamap simple_agg"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id,sum(age) from mainTable group by id"})).s((Seq)Nil$.MODULE$)).explain(true);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select sub.id from (select id ,sum(age) from mainTable group by id) sub where sub\n           |.id = 4"})).s((Seq)Nil$.MODULE$))).stripMargin()).explain(true);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap simple_agg_with_join using 'mv' as\n         | select id,address, sum(age) from mainTable inner join dimtable on mainTable\n         | .name=dimtable.name group by id ,address"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rebuild datamap simple_agg_with_join"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id,address, sum(age) from mainTable inner join dimtable on mainTable\n           |.name=dimtable.name group by id ,address"})).s((Seq)Nil$.MODULE$))).stripMargin()).explain(true);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id,address, sum(age) from mainTable inner join dimtable on mainTable\n                 |.name=dimtable.name where id =1 group by id ,address"})).s((Seq)Nil$.MODULE$))).stripMargin()).explain(true);
        spark.sql("show datamap").show(false);
        spark.sql("drop datamap if exists simple_agg_with_join");
        spark.sql("DROP TABLE IF EXISTS mainTable");
        spark.sql("DROP TABLE IF EXISTS dimtable");
    }

    private void performanceTest(SparkSession spark) {
        spark.sql("DROP TABLE IF EXISTS employee_salary");
        spark.sql("DROP TABLE IF EXISTS employee_salary_without_mv");
        spark.sql("DROP TABLE IF EXISTS emp_address");
        this.createFactTable(spark, "employee_salary");
        this.createFactTable(spark, "employee_salary_without_mv");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE emp_address\n        | (name String,\n        | address String)\n        | STORED BY 'org.apache.carbondata.format'\n      ")).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into emp_address select name, concat(city, ' street1') as address from\n         |employee_salary group by name, address"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap simple_agg_employee using 'mv' as\n         | select id,sum(salary) from employee_salary group by id"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rebuild datamap simple_agg_employee"})).s((Seq)Nil$.MODULE$));
        double timeWithOutMv = this.time((Function0<BoxedUnit>)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql("select id, name, sum(salary) from employee_salary_without_mv group by id,name").collect();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        double timeWithMv = this.time((Function0<BoxedUnit>)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql("select id,name,sum(salary) from employee_salary group by id,name").collect();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Time of table with MV is : ").append((Object)BoxesRunTime.boxToDouble((double)timeWithMv)).append((Object)" time withoutmv : ").append((Object)BoxesRunTime.boxToDouble((double)timeWithOutMv)).toString());
        double timeWithOutMvFilter = this.time((Function0<BoxedUnit>)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql("select id, name, sum(salary) from employee_salary_without_mv where name='name10' group by id,name").collect();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        double timeWithMvFilter = this.time((Function0<BoxedUnit>)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql("select id,name,sum(salary) from employee_salary where name='name10' group by id,name").collect();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Time of table with MV with filter is : ").append((Object)BoxesRunTime.boxToDouble((double)timeWithMvFilter)).append((Object)" time withoutmv : ").append((Object)BoxesRunTime.boxToDouble((double)timeWithOutMvFilter)).toString());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap simple_join_agg_employee using 'mv' as\n         | select id,address, sum(salary) from employee_salary f join emp_address d\n         | on f.name=d.name group by id,address"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rebuild datamap simple_join_agg_employee"})).s((Seq)Nil$.MODULE$));
        double timeWithMVJoin = this.time((Function0<BoxedUnit>)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id,address, sum(salary) from employee_salary f join emp_address d\n           | on f.name=d.name group by id,address"})).s((Seq)Nil$.MODULE$))).stripMargin()).collect();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        double timeWithOutMVJoin = this.time((Function0<BoxedUnit>)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select id,address, sum(salary) from employee_salary_without_mv f\n           |join emp_address d on f.name=d.name group by id,address"})).s((Seq)Nil$.MODULE$))).stripMargin()).collect();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Time of table with MV with join is : ").append((Object)BoxesRunTime.boxToDouble((double)timeWithMVJoin)).append((Object)" time withoutmv : ").append((Object)BoxesRunTime.boxToDouble((double)timeWithOutMVJoin)).toString());
        spark.sql("DROP TABLE IF EXISTS employee_salary");
        spark.sql("DROP TABLE IF EXISTS emp_address");
        spark.sql("DROP TABLE IF EXISTS employee_salary_without_mv");
    }

    private void createFactTable(SparkSession spark, String tableName) {
        Random rand = new Random();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_MVDataMapExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
            }

            public Org_apache_carbondata_examples_MVDataMapExample$$typecreator5$1() {
            }
        }
        Dataset df = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000000), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(rand){
            public static final long serialVersionUID = 0L;
            private final Random rand$1;

            public final Tuple4<Object, String, String, Object> apply(int x) {
                return new Tuple4((Object)BoxesRunTime.boxToInteger((int)(x % 1000)), (Object)new StringBuilder().append((Object)"name").append((Object)BoxesRunTime.boxToInteger((int)(x % 1000))).toString(), (Object)new StringBuilder().append((Object)"city").append((Object)BoxesRunTime.boxToInteger((int)(x % 100))).toString(), (Object)BoxesRunTime.boxToInteger((int)this.rand$1.nextInt()));
            }
            {
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_MVDataMapExample$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "city", "salary"}));
        df.write().format("carbondata").option("tableName", tableName).save();
    }

    private double time(Function0<BoxedUnit> code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    private MVDataMapExample$() {
        MODULE$ = this;
    }
}

