/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.carbondata.hive.test.server.HiveEmbeddedServer2;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HiveExample$ {
    public static final HiveExample$ MODULE$;
    private final String driverName;
    private final String rootPath;
    private final String targetLoc;
    private final String metaStoreLoc;
    private final String storeLocation;
    private final Logger logger;

    static {
        new HiveExample$();
    }

    private String driverName() {
        return this.driverName;
    }

    public String rootPath() {
        return this.rootPath;
    }

    private String targetLoc() {
        return this.targetLoc;
    }

    public String metaStoreLoc() {
        return this.metaStoreLoc;
    }

    public String storeLocation() {
        return this.storeLocation;
    }

    public Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        this.createCarbonTable(this.storeLocation());
        this.readFromHive();
        System.exit(0);
    }

    public void createCarbonTable(String store) {
        SparkSession carbonSession = ExampleUtils$.MODULE$.createCarbonSession("HiveExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString("DROP TABLE IF EXISTS HIVE_CARBON_EXAMPLE")).stripMargin());
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE HIVE_CARBON_EXAMPLE\n         | (ID int,NAME string,SALARY double)\n         | STORED BY 'carbondata'\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        String inputPath = FileFactory.getUpdatedFilePath((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/src/main/resources/sample.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rootPath()})));
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | LOAD DATA LOCAL INPATH '", "'\n         | INTO TABLE HIVE_CARBON_EXAMPLE\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputPath})))).stripMargin());
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | LOAD DATA LOCAL INPATH '", "'\n         | INTO TABLE HIVE_CARBON_EXAMPLE\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputPath})))).stripMargin());
        carbonSession.sql("SELECT * FROM HIVE_CARBON_EXAMPLE").show();
        carbonSession.sql("DROP TABLE IF EXISTS TEST_BOUNDARY");
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE TEST_BOUNDARY (c1_int int,c2_Bigint Bigint,c3_Decimal Decimal(38,30),\n           |c4_double double,c5_string string,c6_Timestamp Timestamp,c7_Datatype_Desc string)\n           |STORED BY 'org.apache.carbondata.format' TBLPROPERTIES\n           |('DICTIONARY_INCLUDE'='c6_Timestamp')"})).s((Seq)Nil$.MODULE$))).stripMargin());
        inputPath = FileFactory.getUpdatedFilePath((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/src/main/resources/Test_Data1.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rootPath()})));
        carbonSession.sql(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA INPATH '", "' INTO table TEST_BOUNDARY OPTIONS('DELIMITER'=',',"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputPath}))).append((Object)"'QUOTECHAR'='\"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='c1_int,c2_Bigint,").append((Object)"c3_Decimal,c4_double,c5_string,c6_Timestamp,c7_Datatype_Desc')").toString());
        carbonSession.close();
        this.checkAndDeleteDBLock();
    }

    public void checkAndDeleteDBLock() {
        String dbLockPath = FileFactory.getUpdatedFilePath((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/db.lck"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metaStoreLoc()})));
        String dbexLockPath = FileFactory.getUpdatedFilePath((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/dbex.lck"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metaStoreLoc()})));
        Object object = FileFactory.isFileExist((String)dbLockPath) ? BoxesRunTime.boxToBoolean((boolean)FileFactory.deleteFile((String)dbLockPath, (FileFactory.FileType)FileFactory.getFileType((String)dbLockPath))) : BoxedUnit.UNIT;
        if (FileFactory.isFileExist((String)dbexLockPath)) {
            FileFactory.deleteFile((String)dbexLockPath, (FileFactory.FileType)FileFactory.getFileType((String)dbexLockPath));
        }
    }

    public void readFromHive() {
        BoxedUnit boxedUnit;
        try {
            boxedUnit = Class.forName(this.driverName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            boxedUnit = BoxedUnit.UNIT;
        }
        Path path = new Path(this.targetLoc());
        FileSystem fileSys = path.getFileSystem(FileFactory.getConfiguration());
        fileSys.setPermission(path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        HiveEmbeddedServer2 hiveEmbeddedServer2 = new HiveEmbeddedServer2();
        hiveEmbeddedServer2.start(this.targetLoc());
        int port = hiveEmbeddedServer2.getFreePort();
        Connection connection = DriverManager.getConnection(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:hive2://localhost:", "/default"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})), "", "");
        Statement statement = connection.createStatement();
        this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"============HIVE CLI IS STARTED ON PORT ", " =============="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
        ResultSet resultSet = statement.executeQuery("SELECT * FROM HIVE_CARBON_EXAMPLE");
        int rowsFetched = 0;
        String resultId = "";
        String resultName = "";
        String resultSalary = "";
        while (resultSet.next()) {
            if (rowsFetched == 0) {
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                Predef$.MODULE$.println((Object)"| ID|| NAME || SALARY        |");
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                resultId = resultSet.getString("id");
                resultName = resultSet.getString("name");
                resultSalary = resultSet.getString("salary");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            } else {
                resultId = resultSet.getString("ID");
                resultName = resultSet.getString("NAME");
                resultSalary = resultSet.getString("SALARY");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            }
            ++rowsFetched;
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"******Total Number Of Rows Fetched ****** ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rowsFetched)})));
        Predef$.MODULE$.assert(rowsFetched == 4);
        this.logger().info((Object)"Fetching the Individual Columns ");
        int individualColRowsFetched = 0;
        ResultSet resultIndividualCol = statement.executeQuery("SELECT NAME FROM HIVE_CARBON_EXAMPLE");
        while (resultIndividualCol.next()) {
            if (individualColRowsFetched == 0) {
                Predef$.MODULE$.println((Object)"+--------------+");
                Predef$.MODULE$.println((Object)"| NAME         |");
                Predef$.MODULE$.println((Object)"+---++---------+");
                resultName = resultIndividualCol.getString("name");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName})));
                Predef$.MODULE$.println((Object)"+---++---------+");
            } else {
                resultName = resultIndividualCol.getString("NAME");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "      |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName})));
                Predef$.MODULE$.println((Object)"+---++---------+");
            }
            ++individualColRowsFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)" ********** Total Rows Fetched When Quering The Individual Columns **********").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)individualColRowsFetched)}))).toString());
        Predef$.MODULE$.assert(individualColRowsFetched == 4);
        this.logger().info((Object)"Fetching the Out Of Order Columns ");
        ResultSet resultOutOfOrderCol = statement.executeQuery("SELECT SALARY,ID,NAME FROM HIVE_CARBON_EXAMPLE");
        int outOfOrderColFetched = 0;
        while (resultOutOfOrderCol.next()) {
            if (outOfOrderColFetched == 0) {
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                Predef$.MODULE$.println((Object)"| Salary|| ID || NAME        |");
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                resultId = resultOutOfOrderCol.getString("id");
                resultName = resultOutOfOrderCol.getString("name");
                resultSalary = resultOutOfOrderCol.getString("salary");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            } else {
                resultId = resultOutOfOrderCol.getString("ID");
                resultName = resultOutOfOrderCol.getString("NAME");
                resultSalary = resultOutOfOrderCol.getString("SALARY");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            }
            ++outOfOrderColFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)" ********** Total Rows Fetched When Quering The Out Of Order Columns **********").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outOfOrderColFetched)}))).toString());
        Predef$.MODULE$.assert(outOfOrderColFetched == 4);
        ResultSet resultAggQuery = statement.executeQuery("SELECT min(c3_Decimal) as min, max(c3_Decimal) as max, sum(c3_Decimal) as sum FROM TEST_BOUNDARY");
        int resultAggQueryFetched = 0;
        String resultMin = "";
        String resultMax = "";
        String resultSum = "";
        while (resultAggQuery.next()) {
            if (resultAggQueryFetched == 0) {
                Predef$.MODULE$.println((Object)"+-----++-------------------++--------------------------------+");
                Predef$.MODULE$.println((Object)"| min || max               || sum                            |");
                Predef$.MODULE$.println((Object)"+-----++-------------------++--------------------------------+");
                resultMin = resultAggQuery.getString("min");
                resultMax = resultAggQuery.getString("max");
                resultSum = resultAggQuery.getString("sum");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultMin}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultMax}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "|"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSum}))).toString());
                Predef$.MODULE$.println((Object)"+-----++-------------------++--------------------------------+");
            }
            ++resultAggQueryFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)" ********** Total Rows Fetched When Aggregate Query **********").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)resultAggQueryFetched)}))).toString());
        Predef$.MODULE$.assert(resultAggQueryFetched == 1);
        hiveEmbeddedServer2.stop();
    }

    private HiveExample$() {
        MODULE$ = this;
        this.driverName = "org.apache.hive.jdbc.HiveDriver";
        this.rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        this.targetLoc = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rootPath()}));
        this.metaStoreLoc = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/metastore_db"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetLoc()}));
        this.storeLocation = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetLoc()}));
        this.logger = LogServiceFactory.getLogService((String)this.getClass().getCanonicalName());
    }
}

