/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class CarbonSessionExample$ {
    public static final CarbonSessionExample$ MODULE$;

    static {
        new CarbonSessionExample$();
    }

    public void main(String[] args) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        System.setProperty("path.target", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})));
        PropertyConfigurator.configure((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/src/main/resources/log4j.properties"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})));
        CarbonProperties.getInstance().addProperty("enable.query.statistics", "true");
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("CarbonSessionExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        spark.sparkContext().setLogLevel("INFO");
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        spark.sql("DROP TABLE IF EXISTS source");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE source(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5),\n         | floatField FLOAT\n         | )\n         | STORED AS carbondata\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/src/main/resources/data.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | LOAD DATA LOCAL INPATH '", "'\n         | INTO TABLE source\n         | OPTIONS('HEADER'='true', 'COMPLEX_DELIMITER_LEVEL_1'='#')\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT charField, stringField, intField\n         | FROM source\n         | WHERE stringfield = 'spark' AND decimalField > 40\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT *\n         | FROM source WHERE length(stringField) = 5\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT *\n         | FROM source WHERE date_format(dateField, \"yyyy-MM-dd\") = \"2015-07-23\"\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql("SELECT count(stringField) FROM source").show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT sum(intField), stringField\n         | FROM source\n         | GROUP BY stringField\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT t1.*, t2.*\n         | FROM source t1, source t2\n         | WHERE t1.stringField = t2.stringField\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | WITH t1 AS (\n         | SELECT * FROM source\n         | UNION ALL\n         | SELECT * FROM source\n         | )\n         | SELECT t1.*, t2.*\n         | FROM t1, source t2\n         | WHERE t1.stringField = t2.stringField\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT *\n         | FROM source\n         | WHERE stringField = 'spark' and floatField > 2.8\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql("DROP TABLE IF EXISTS source");
    }

    private CarbonSessionExample$() {
        MODULE$ = this;
    }
}

